/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.DateTimePeriod;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantJvmKt;
import kotlinx.datetime.MathKt;
import kotlinx.datetime.TimeZone;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u001a\u0010\b\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\"\u0010\r\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\r\u001a\u00020\u0010*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\u0011\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\u0012\u001a\u00020\u0005*\u00020\u0013\u001a\u001a\u0010\u0014\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\u0015"}, d2={"DISTANT_FUTURE_SECONDS", "", "DISTANT_PAST_SECONDS", "isDistantFuture", "", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)Z", "isDistantPast", "daysUntil", "", "other", "timeZone", "Lkotlinx/datetime/TimeZone;", "minus", "unit", "Lkotlinx/datetime/DateTimeUnit;", "Lkotlinx/datetime/DateTimePeriod;", "monthsUntil", "toInstant", "", "yearsUntil", "kotlinx-datetime"})
public final class InstantKt {
    public static final long DISTANT_PAST_SECONDS = -3217862419201L;
    public static final long DISTANT_FUTURE_SECONDS = 3093527980800L;

    public static final boolean isDistantPast(@NotNull Instant $this$isDistantPast) {
        Intrinsics.checkNotNullParameter((Object)$this$isDistantPast, (String)"$this$isDistantPast");
        return $this$isDistantPast.compareTo(Instant.Companion.getDISTANT_PAST()) <= 0;
    }

    public static final boolean isDistantFuture(@NotNull Instant $this$isDistantFuture) {
        Intrinsics.checkNotNullParameter((Object)$this$isDistantFuture, (String)"$this$isDistantFuture");
        return $this$isDistantFuture.compareTo(Instant.Companion.getDISTANT_FUTURE()) >= 0;
    }

    @NotNull
    public static final Instant toInstant(@NotNull String $this$toInstant) {
        Intrinsics.checkNotNullParameter((Object)$this$toInstant, (String)"$this$toInstant");
        return Instant.Companion.parse($this$toInstant);
    }

    public static final int daysUntil(@NotNull Instant $this$daysUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$daysUntil, (String)"$this$daysUntil");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$daysUntil, other, DateTimeUnit.Companion.getDAY(), timeZone));
    }

    public static final int monthsUntil(@NotNull Instant $this$monthsUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$monthsUntil, (String)"$this$monthsUntil");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$monthsUntil, other, DateTimeUnit.Companion.getMONTH(), timeZone));
    }

    public static final int yearsUntil(@NotNull Instant $this$yearsUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$yearsUntil, (String)"$this$yearsUntil");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$yearsUntil, other, DateTimeUnit.Companion.getYEAR(), timeZone));
    }

    @NotNull
    public static final DateTimePeriod minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"$this$minus");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return InstantJvmKt.periodUntil(other, $this$minus, timeZone);
    }

    public static final long minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"$this$minus");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return InstantJvmKt.until(other, $this$minus, unit, timeZone);
    }
}

