package kotlinx.html

import kotlin.contracts.ExperimentalContracts
import kotlin.contracts.InvocationKind
import kotlin.contracts.contract
import kotlinx.html.*
import kotlinx.html.impl.*
import kotlinx.html.attributes.*

/*******************************************************************************
    DO NOT EDIT
    This file was generated by module generate
*******************************************************************************/

@Suppress("unused")
open class P(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("p", consumer, initialAttributes, null, false, false), HtmlBlockInlineTag {

}
val P.asFlowContent : FlowContent
    get()  = this

val P.asPhrasingContent : PhrasingContent
    get()  = this


@Suppress("unused")
open class PARAM(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("param", consumer, initialAttributes, null, true, true), CoreAttributeGroupFacade {
    var name : String
        get()  = attributeStringString[this, "name"]
        set(newValue) {attributeStringString[this, "name"] = newValue}

    var value : String
        get()  = attributeStringString[this, "value"]
        set(newValue) {attributeStringString[this, "value"] = newValue}


}

@Suppress("unused")
open class PICTURE(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("picture", consumer, initialAttributes, null, false, false), FlowInteractivePhrasingContent {

}
/**
 * Media source for 
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun PICTURE.source(classes : String? = null, crossinline block : SOURCE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SOURCE(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Embedded image
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun PICTURE.img(alt : String? = null, src : String? = null, loading : ImgLoading? = null, classes : String? = null, crossinline block : IMG.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    IMG(attributesMapOf("alt", alt,"src", src,"loading", loading?.enumEncode(),"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun PICTURE.eagerImg(alt : String? = null, src : String? = null, classes : String? = null, crossinline block : IMG.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    IMG(attributesMapOf("alt", alt,"src", src,"loading", ImgLoading.eager.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun PICTURE.lazyImg(alt : String? = null, src : String? = null, classes : String? = null, crossinline block : IMG.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    IMG(attributesMapOf("alt", alt,"src", src,"loading", ImgLoading.lazy.realValue,"class", classes), consumer).visit(block)
}

val PICTURE.asFlowContent : FlowContent
    get()  = this

val PICTURE.asInteractiveContent : InteractiveContent
    get()  = this

val PICTURE.asPhrasingContent : PhrasingContent
    get()  = this


@Suppress("unused")
open class PRE(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("pre", consumer, initialAttributes, null, false, false), HtmlBlockInlineTag {

}
val PRE.asFlowContent : FlowContent
    get()  = this

val PRE.asPhrasingContent : PhrasingContent
    get()  = this


@Suppress("unused")
open class PROGRESS(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("progress", consumer, initialAttributes, null, true, false), HtmlBlockInlineTag {
    var value : String
        get()  = attributeStringString[this, "value"]
        set(newValue) {attributeStringString[this, "value"] = newValue}

    var max : String
        get()  = attributeStringString[this, "max"]
        set(newValue) {attributeStringString[this, "max"] = newValue}


}
val PROGRESS.asFlowContent : FlowContent
    get()  = this

val PROGRESS.asPhrasingContent : PhrasingContent
    get()  = this


