/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.charsets;

import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.charsets.CharsetJVMKt;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.ByteReadPacketBase;
import kotlinx.io.core.Input;
import kotlinx.io.core.InputKt;
import kotlinx.io.core.IoBuffer;
import kotlinx.io.core.Output;
import kotlinx.io.core.PacketJVMKt;
import kotlinx.io.core.StringsKt;
import kotlinx.io.core.internal.UnsafeKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\u001a \u0010\u0002\u001a\u00020\u0003*\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a*\u0010\n\u001a\u00020\u000b*\u00060\fj\u0002`\r2\u0006\u0010\u0006\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\t\u001a.\u0010\n\u001a\u00020\u0011*\u00060\fj\u0002`\r2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0018\u0010\u0014\u001a\u00020\u0011*\u00060\fj\u0002`\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a*\u0010\u0015\u001a\u00020\u0001*\u00060\fj\u0002`\r2\u0006\u0010\u0006\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\t\u001a\u0016\u0010\u0016\u001a\u00020\u000b*\u00060\fj\u0002`\r2\u0006\u0010\u0006\u001a\u00020\u000b\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"EmptyByteArray", "", "decode", "", "Ljava/nio/charset/CharsetDecoder;", "Lkotlinx/io/charsets/CharsetDecoder;", "input", "Lkotlinx/io/core/Input;", "max", "", "encode", "Lkotlinx/io/core/ByteReadPacket;", "Ljava/nio/charset/CharsetEncoder;", "Lkotlinx/io/charsets/CharsetEncoder;", "", "fromIndex", "toIndex", "", "dst", "Lkotlinx/io/core/Output;", "encodeCompleteImpl", "encodeToByteArrayImpl", "encodeUTF8", "sizeEstimate", "", "kotlinx-io"})
public final class EncodingKt {
    private static final byte[] EmptyByteArray = new byte[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void encode(@NotNull CharsetEncoder $receiver, @NotNull CharSequence input, int fromIndex, int toIndex, @NotNull Output dst) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        int start = fromIndex;
        if (start >= toIndex) {
            return;
        }
        Output output = dst;
        int initialSize$iv = 1;
        boolean $i$f$writeWhileSize = false;
        IoBuffer tail$iv = UnsafeKt.prepareWriteHead((Output)$receiver$iv, initialSize$iv, null);
        try {
            int size$iv = 0;
            while (true) {
                boolean bl;
                IoBuffer view = tail$iv;
                boolean bl2 = false;
                int rc = CharsetJVMKt.encodeImpl($receiver, input, start, toIndex, view);
                boolean bl3 = bl = rc >= 0;
                if (!bl) {
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                size$iv = (start += rc) >= toIndex ? 0 : (rc == 0 ? 8 : 1);
                if (size$iv <= 0) {
                    break;
                }
                tail$iv = UnsafeKt.prepareWriteHead((Output)$receiver$iv, size$iv, tail$iv);
            }
        }
        finally {
            UnsafeKt.afterHeadWrite((Output)$receiver$iv, tail$iv);
        }
        EncodingKt.encodeCompleteImpl($receiver, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] encodeToByteArrayImpl(@NotNull CharsetEncoder $receiver, @NotNull CharSequence input, int fromIndex, int toIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        int start = fromIndex;
        if (start >= toIndex) {
            return EmptyByteArray;
        }
        IoBuffer single = IoBuffer.Companion.getPool().borrow();
        try {
            IoBuffer.Companion.getNoPool();
            int rc = CharsetJVMKt.encodeImpl($receiver, input, start, toIndex, single);
            if ((start += rc) == toIndex) {
                byte[] result = new byte[single.getReadRemaining()];
                InputKt.readFully$default((Input)single, result, 0, 0, 6, null);
                byte[] byArray = result;
                return byArray;
            }
            BytePacketBuilder builder = new BytePacketBuilder(0, IoBuffer.Companion.getPool());
            builder.last$kotlinx_io(single.makeView());
            EncodingKt.encode($receiver, input, start, toIndex, builder);
            byte[] byArray = StringsKt.readBytes$default(builder.build(), 0, 1, null);
            return byArray;
        }
        finally {
            single.release(IoBuffer.Companion.getPool());
        }
    }

    @NotNull
    public static /* synthetic */ byte[] encodeToByteArrayImpl$default(CharsetEncoder charsetEncoder, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return EncodingKt.encodeToByteArrayImpl(charsetEncoder, charSequence, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void encodeCompleteImpl(@NotNull CharsetEncoder $receiver, Output dst) {
        int size = 1;
        Output $receiver$iv = dst;
        boolean $i$f$writeWhile = false;
        IoBuffer tail$iv = UnsafeKt.prepareWriteHead($receiver$iv, 1, null);
        try {
            while (true) {
                IoBuffer view = tail$iv;
                boolean bl = false;
                if (CharsetJVMKt.encodeComplete($receiver, view)) {
                    size = 0;
                } else {
                    int n = size;
                    size = n + 1;
                }
                if (!(size > 0)) {
                    break;
                }
                tail$iv = UnsafeKt.prepareWriteHead($receiver$iv, 1, tail$iv);
            }
        }
        finally {
            UnsafeKt.afterHeadWrite($receiver$iv, tail$iv);
        }
    }

    @NotNull
    public static final ByteReadPacket encode(@NotNull CharsetEncoder $receiver, @NotNull CharSequence input, int fromIndex, int toIndex) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver2 = builder$iv;
            boolean bl = false;
            EncodingKt.encode($receiver, input, fromIndex, toIndex, $receiver2);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    @NotNull
    public static /* synthetic */ ByteReadPacket encode$default(CharsetEncoder charsetEncoder, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return EncodingKt.encode(charsetEncoder, charSequence, n, n2);
    }

    @NotNull
    public static final ByteReadPacket encodeUTF8(@NotNull CharsetEncoder $receiver, @NotNull ByteReadPacket input) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $receiver2 = builder$iv;
            boolean bl = false;
            CharsetJVMKt.encodeUTF8($receiver, input, $receiver2);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    @NotNull
    public static final String decode(@NotNull CharsetDecoder $receiver, @NotNull Input input, int max) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        long l = max;
        long l2 = EncodingKt.sizeEstimate(input);
        int n = (int)Math.min(l, l2);
        StringBuilder $receiver2 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        CharsetJVMKt.decode($receiver, input, $receiver2, max);
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    @NotNull
    public static /* synthetic */ String decode$default(CharsetDecoder charsetDecoder, Input input, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return EncodingKt.decode(charsetDecoder, input, n);
    }

    public static final long sizeEstimate(@NotNull Input $receiver) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Input input = $receiver;
        if (input instanceof ByteReadPacket) {
            l = ((ByteReadPacket)$receiver).getRemaining();
        } else if (input instanceof ByteReadPacketBase) {
            long l2 = ((ByteReadPacketBase)$receiver).getRemaining();
            long l3 = 16L;
            l = Math.max(l2, l3);
        } else {
            l = 16L;
        }
        return l;
    }
}

