/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.core;

import java.io.EOFException;
import java.nio.ByteBuffer;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.AbstractInput;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.ByteReadPacketBase;
import kotlinx.io.core.IoBuffer;
import kotlinx.io.core.internal.RequireFailureCapture;
import kotlinx.io.internal.jvm.ErrorsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001d\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0082\u0010\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0004\u001a)\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\rH\u0086\b\u001a)\u0010\b\u001a\u00020\t*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\rH\u0086\b\u001a)\u0010\b\u001a\u00020\t*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\rH\u0087\b\u001a\u0012\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0004\u001a)\u0010\u0010\u001a\u00020\t*\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\rH\u0086\b\u001a\u0014\u0010\u0012\u001a\u00020\t*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0004H\u0007\u00a8\u0006\u0014"}, d2={"readAsMuchAsPossible", "", "Lkotlinx/io/core/ByteReadPacket;", "bb", "Ljava/nio/ByteBuffer;", "copied", "readAvailable", "dst", "readDirect", "", "Lkotlinx/io/core/AbstractInput;", "size", "block", "Lkotlin/Function1;", "Lkotlinx/io/core/ByteReadPacketBase;", "readFully", "writeDirect", "Lkotlinx/io/core/BytePacketBuilder;", "writeFully", "src", "kotlinx-io"})
public final class ByteBuffersKt {
    public static final int readAvailable(@NotNull ByteReadPacket $receiver, @NotNull ByteBuffer dst) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        return ByteBuffersKt.readAsMuchAsPossible($receiver, dst, 0);
    }

    public static final int readFully(@NotNull ByteReadPacket $receiver, @NotNull ByteBuffer dst) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        int rc = ByteBuffersKt.readAsMuchAsPossible($receiver, dst, 0);
        if (dst.hasRemaining()) {
            throw (Throwable)new EOFException("Not enough data in packet to fill buffer: " + dst.remaining() + " more bytes required");
        }
        return rc;
    }

    /*
     * WARNING - void declaration
     */
    private static final int readAsMuchAsPossible(@NotNull ByteReadPacket $receiver, ByteBuffer bb, int copied) {
        IoBuffer current;
        int destinationCapacity;
        while (true) {
            void this_$iv;
            if (!bb.hasRemaining()) {
                return copied;
            }
            ByteReadPacket byteReadPacket = $receiver;
            int minSize$iv = 1;
            boolean $i$f$prepareRead$kotlinx_io = false;
            if (this_$iv.prepareRead(minSize$iv, this_$iv.getHead()) == null) {
                return copied;
            }
            destinationCapacity = bb.remaining();
            int available = current.getReadRemaining();
            if (destinationCapacity < available) break;
            current.readFully(bb, available);
            $receiver.releaseHead$kotlinx_io(current);
            copied += available;
        }
        current.readFully(bb, destinationCapacity);
        $receiver.updateHeadRemaining(current.getReadRemaining());
        return copied + destinationCapacity;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeDirect(@NotNull BytePacketBuilder $receiver, int size, @NotNull Function1<? super ByteBuffer, Unit> block) {
        void this_$iv$iv$iv;
        void this_$iv;
        void buffer;
        int $i$f$writeDirect = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        BytePacketBuilder this_$iv2 = $receiver;
        boolean $i$f$write = false;
        IoBuffer buffer$iv = this_$iv2.getTail();
        if (buffer$iv.getWriteRemaining() < size) {
            buffer$iv = this_$iv2.appendNewBuffer();
        }
        IoBuffer ioBuffer = buffer$iv;
        BytePacketBuilder bytePacketBuilder = this_$iv2;
        boolean bl = false;
        void var9_10 = buffer;
        int size$iv = size;
        boolean $i$f$writeDirect2 = false;
        int rem$iv = this_$iv.getWriteRemaining();
        boolean condition$iv$iv = size$iv <= rem$iv;
        boolean $i$f$require = false;
        if (!condition$iv$iv) {
            RequireFailureCapture m$iv$iv = new RequireFailureCapture(size$iv, rem$iv){
                final /* synthetic */ int $size$inlined;
                final /* synthetic */ int $rem$inlined;
                {
                    this.$size$inlined = n;
                    this.$rem$inlined = n2;
                }

                @NotNull
                public Void doFail() {
                    String string;
                    boolean bl = false;
                    String string2 = string = "size " + this.$size$inlined + " is greater than buffer's remaining capacity " + this.$rem$inlined;
                    throw (Throwable)new IllegalArgumentException(string2);
                }
            };
            Void void_ = m$iv$iv.doFail();
            throw null;
        }
        ByteBuffer buffer$iv2 = this_$iv.writeBuffer;
        int positionBefore$iv = buffer$iv2.position();
        block.invoke((Object)buffer$iv2);
        int delta$iv = buffer$iv2.position() - positionBefore$iv;
        if (delta$iv < 0 || delta$iv > rem$iv) {
            Void void_ = ErrorsKt.wrongBufferPositionChangeError(delta$iv, size$iv);
            throw null;
        }
        void this_$iv$iv = this_$iv;
        boolean $i$f$afterWrite = false;
        void var18_21 = this_$iv$iv;
        ByteBuffer byteBuffer = this_$iv$iv.readBuffer;
        boolean $i$f$getWritePosition = false;
        int n = this_$iv$iv$iv.writeBuffer.position();
        byteBuffer.limit(n);
        int n2 = delta$iv;
        bytePacketBuilder.addSize(n2);
    }

    public static final void readDirect(@NotNull ByteReadPacket $receiver, int size, @NotNull Function1<? super ByteBuffer, Unit> block) {
        IoBuffer buffer$iv;
        IoBuffer ioBuffer;
        int $i$f$readDirect = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ByteReadPacket this_$iv = $receiver;
        boolean $i$f$read = false;
        IoBuffer head$iv = this_$iv.getHead();
        int before$iv = head$iv.getReadRemaining();
        if (before$iv < size) {
            IoBuffer ioBuffer2;
            IoBuffer it$iv = ioBuffer2 = this_$iv.prepareRead(size, head$iv);
            boolean bl = false;
            IoBuffer ioBuffer3 = it$iv;
            before$iv = ioBuffer3 != null ? ioBuffer3.getReadRemaining() : 0;
            ioBuffer = ioBuffer2;
        } else {
            ioBuffer = buffer$iv = head$iv;
        }
        if (buffer$iv != null) {
            IoBuffer view = buffer$iv;
            boolean bl = false;
            IoBuffer this_$iv2 = view;
            boolean $i$f$readDirect2 = false;
            ByteBuffer bb$iv = this_$iv2.readBuffer;
            int positionBefore$iv = bb$iv.position();
            int limit$iv = bb$iv.limit();
            ByteBuffer it = bb$iv;
            boolean bl2 = false;
            block.invoke((Object)it);
            int delta$iv = bb$iv.position() - positionBefore$iv;
            if (delta$iv < 0) {
                Void void_ = ErrorsKt.negativeShiftError(delta$iv);
                throw null;
            }
            if (bb$iv.limit() != limit$iv) {
                Void void_ = ErrorsKt.limitChangeError();
                throw null;
            }
            int after$iv = buffer$iv.getReadRemaining();
            int delta$iv2 = before$iv - after$iv;
            if (delta$iv2 > 0) {
                ByteReadPacket byteReadPacket = this_$iv;
                byteReadPacket.setHeadRemaining(byteReadPacket.getHeadRemaining() - delta$iv2);
            }
            if (after$iv == 0) {
                this_$iv.ensureNext(buffer$iv);
            }
        }
    }

    public static final void readDirect(@NotNull AbstractInput $receiver, int size, @NotNull Function1<? super ByteBuffer, Unit> block) {
        IoBuffer buffer$iv;
        IoBuffer ioBuffer;
        int $i$f$readDirect = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        AbstractInput this_$iv = $receiver;
        boolean $i$f$read = false;
        IoBuffer head$iv = this_$iv.getHead();
        int before$iv = head$iv.getReadRemaining();
        if (before$iv < size) {
            IoBuffer ioBuffer2;
            IoBuffer it$iv = ioBuffer2 = this_$iv.prepareRead(size, head$iv);
            boolean bl = false;
            IoBuffer ioBuffer3 = it$iv;
            before$iv = ioBuffer3 != null ? ioBuffer3.getReadRemaining() : 0;
            ioBuffer = ioBuffer2;
        } else {
            ioBuffer = buffer$iv = head$iv;
        }
        if (buffer$iv != null) {
            IoBuffer view = buffer$iv;
            boolean bl = false;
            IoBuffer this_$iv2 = view;
            boolean $i$f$readDirect2 = false;
            ByteBuffer bb$iv = this_$iv2.readBuffer;
            int positionBefore$iv = bb$iv.position();
            int limit$iv = bb$iv.limit();
            ByteBuffer it = bb$iv;
            boolean bl2 = false;
            block.invoke((Object)it);
            int delta$iv = bb$iv.position() - positionBefore$iv;
            if (delta$iv < 0) {
                Void void_ = ErrorsKt.negativeShiftError(delta$iv);
                throw null;
            }
            if (bb$iv.limit() != limit$iv) {
                Void void_ = ErrorsKt.limitChangeError();
                throw null;
            }
            int after$iv = buffer$iv.getReadRemaining();
            int delta$iv2 = before$iv - after$iv;
            if (delta$iv2 > 0) {
                AbstractInput abstractInput = this_$iv;
                abstractInput.setHeadRemaining(abstractInput.getHeadRemaining() - delta$iv2);
            }
            if (after$iv == 0) {
                this_$iv.ensureNext(buffer$iv);
            }
        }
    }

    @Deprecated(message="Removed", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ void readDirect(@NotNull ByteReadPacketBase $receiver, int size, @NotNull Function1<? super ByteBuffer, Unit> block) {
        IoBuffer buffer$iv;
        IoBuffer ioBuffer;
        int $i$f$readDirect = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ByteReadPacketBase this_$iv = $receiver;
        boolean $i$f$read = false;
        IoBuffer head$iv = this_$iv.getHead();
        int before$iv = head$iv.getReadRemaining();
        if (before$iv < size) {
            IoBuffer ioBuffer2;
            IoBuffer it$iv = ioBuffer2 = this_$iv.prepareRead(size, head$iv);
            boolean bl = false;
            IoBuffer ioBuffer3 = it$iv;
            before$iv = ioBuffer3 != null ? ioBuffer3.getReadRemaining() : 0;
            ioBuffer = ioBuffer2;
        } else {
            ioBuffer = buffer$iv = head$iv;
        }
        if (buffer$iv != null) {
            IoBuffer view = buffer$iv;
            boolean bl = false;
            IoBuffer this_$iv2 = view;
            boolean $i$f$readDirect2 = false;
            ByteBuffer bb$iv = this_$iv2.readBuffer;
            int positionBefore$iv = bb$iv.position();
            int limit$iv = bb$iv.limit();
            ByteBuffer it = bb$iv;
            boolean bl2 = false;
            block.invoke((Object)it);
            int delta$iv = bb$iv.position() - positionBefore$iv;
            if (delta$iv < 0) {
                Void void_ = ErrorsKt.negativeShiftError(delta$iv);
                throw null;
            }
            if (bb$iv.limit() != limit$iv) {
                Void void_ = ErrorsKt.limitChangeError();
                throw null;
            }
            int after$iv = buffer$iv.getReadRemaining();
            int delta$iv2 = before$iv - after$iv;
            if (delta$iv2 > 0) {
                ByteReadPacketBase byteReadPacketBase = this_$iv;
                byteReadPacketBase.setHeadRemaining(byteReadPacketBase.getHeadRemaining() - delta$iv2);
            }
            if (after$iv == 0) {
                this_$iv.ensureNext(buffer$iv);
            }
        }
    }

    @Deprecated(message="Should be resolved to member function instead", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ void writeFully(@NotNull BytePacketBuilder $receiver, @NotNull ByteBuffer src) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        $receiver.writeFully(src);
    }
}

