/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.knit;

import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.knit.KnitContext;
import kotlinx.knit.KnitKt;
import kotlinx.knit.KnitPluginExtension;
import kotlinx.knit.KnitTask;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lkotlinx/knit/KnitTask;", "Lorg/gradle/api/DefaultTask;", "()V", "check", "", "getCheck", "()Z", "setCheck", "(Z)V", "ext", "Lkotlinx/knit/KnitPluginExtension;", "files", "Lorg/gradle/api/file/FileCollection;", "getFiles", "()Lorg/gradle/api/file/FileCollection;", "setFiles", "(Lorg/gradle/api/file/FileCollection;)V", "rootDir", "Ljava/io/File;", "getRootDir", "()Ljava/io/File;", "setRootDir", "(Ljava/io/File;)V", "knit", "", "kotlinx-knit"})
public class KnitTask
extends DefaultTask {
    @NotNull
    private final KnitPluginExtension ext;
    @Input
    private boolean check;
    @Internal
    @NotNull
    private File rootDir;
    @Internal
    @NotNull
    private FileCollection files;

    public KnitTask() {
        Object object = this.getProject().getExtensions().getByType(KnitPluginExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.getBy\u2026ginExtension::class.java)");
        this.ext = (KnitPluginExtension)object;
        File file = this.ext.getRootDir();
        if (file == null) {
            File file2 = this.getProject().getRootDir();
            file = file2;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.rootDir");
        }
        this.rootDir = file;
        FileCollection fileCollection = this.ext.getFiles();
        if (fileCollection == null) {
            Function1 function1 = files.1.INSTANCE;
            ConfigurableFileTree configurableFileTree = this.getProject().fileTree((Object)this.getProject().getRootDir(), new Action(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ void execute(Object p0) {
                    this.function.invoke(p0);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)configurableFileTree, (String)"project.fileTree(project\u2026ude(\"**/.gradle/*\")\n    }");
            fileCollection = (FileCollection)configurableFileTree;
        }
        this.files = fileCollection;
        Function1 function1 = 1.INSTANCE;
        this.getOutputs().upToDateWhen(new Spec(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean isSatisfiedBy(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        });
    }

    public final boolean getCheck() {
        return this.check;
    }

    public final void setCheck(boolean bl) {
        this.check = bl;
    }

    @NotNull
    public final File getRootDir() {
        return this.rootDir;
    }

    public final void setRootDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.rootDir = file;
    }

    @NotNull
    public final FileCollection getFiles() {
        return this.files;
    }

    public final void setFiles(@NotNull FileCollection fileCollection) {
        Intrinsics.checkNotNullParameter((Object)fileCollection, (String)"<set-?>");
        this.files = fileCollection;
    }

    @TaskAction
    public final void knit() {
        Set set = this.files.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"files.files");
        KnitContext ctx = this.ext.createContext(set, this.rootDir, this.check);
        if (!KnitKt.process(ctx) || this.check && ctx.getLog().getHasWarningOrError()) {
            String extra = ctx.getLog().getNOutdated() > 0 ? "\nRun 'knit' task to write " + ctx.getLog().getNOutdated() + " missing/outdated files." : "";
            throw new GradleException(this.getName() + " task failed, see log for details (use '--info' for detailed log)." + extra);
        }
    }
}

