/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.knit;

import freemarker.template.Configuration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.knit.PropsLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkotlinx/knit/ResourcesProps;", "Lkotlinx/knit/PropsLocation;", "()V", "classLoader", "Ljava/lang/ClassLoader;", "cannotFind", "", "name", "", "open", "Ljava/io/InputStream;", "resolveFile", "Ljava/io/File;", "toString", "initTemplate", "", "Lfreemarker/template/Configuration;", "kotlinx-knit"})
final class ResourcesProps
extends PropsLocation {
    @NotNull
    public static final ResourcesProps INSTANCE = new ResourcesProps();
    @NotNull
    private static final ClassLoader classLoader;

    private ResourcesProps() {
    }

    @Override
    public void initTemplate(@NotNull Configuration $this$initTemplate) {
        Intrinsics.checkNotNullParameter((Object)$this$initTemplate, (String)"<this>");
        $this$initTemplate.setClassLoaderForTemplateLoading(classLoader, "");
    }

    @Override
    @NotNull
    public InputStream open(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        InputStream inputStream = classLoader.getResourceAsStream(name);
        if (inputStream == null) {
            this.cannotFind(name);
            throw new KotlinNothingValueException();
        }
        return inputStream;
    }

    private final Void cannotFind(String name) {
        throw new FileNotFoundException("Cannot find resource: " + name);
    }

    @Override
    @NotNull
    public File resolveFile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        throw (Throwable)new IllegalStateException(("Cannot specify '" + name + "' property in resources").toString());
    }

    @NotNull
    public String toString() {
        return "resources";
    }

    static {
        ClassLoader classLoader = ResourcesProps.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"ResourcesProps::class.java.classLoader");
        ResourcesProps.classLoader = classLoader;
    }
}

