/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.descriptors.ContextAwareKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.ProtoNumber;
import kotlinx.serialization.protobuf.ProtoOneOf;
import kotlinx.serialization.protobuf.ProtoPacked;
import kotlinx.serialization.protobuf.ProtoType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\u00060\u0001j\u0002`\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u0080\b\u00a2\u0006\u0002\u0010\u0012\u001a!\u0010\u001e\u001a\u00060\u0001j\u0002`\u000b*\u00060\u0001j\u0002`\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\u001f\u001a\u001d\u0010 \u001a\u00060\u0001j\u0002`\u000b*\u00020\u00192\u0006\u0010!\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\"\u001a \u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0010H\u0000\u001a\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190'*\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0000\u001a\u001e\u0010*\u001a\u0004\u0018\u00010\u0019*\u00020\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010\f\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\f\u001a\u00020\u0003*\u00060\u0001j\u0002`\u000b8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u001c\u0010\u0015\u001a\u00020\u000e*\u00060\u0001j\u0002`\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0018\u0010\u0018\u001a\u00020\u0010*\u00020\u00198@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\"\u001c\u0010\u001b\u001a\u00020\u0010*\u00060\u0001j\u0002`\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u001c\u0010\u001d\u001a\u00020\u0010*\u00060\u0001j\u0002`\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001c*\f\b\u0000\u0010\u0000\"\u00020\u00012\u00020\u0001\u00a8\u0006+"}, d2={"ProtoDesc", "", "VARINT", "", "i64", "SIZE_DELIMITED", "i32", "ID_HOLDER_ONE_OF", "ONEOFMASK", "INTTYPEMASK", "PACKEDMASK", "Lkotlinx/serialization/protobuf/internal/ProtoDesc;", "protoId", "type", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "packed", "", "oneOf", "(ILkotlinx/serialization/protobuf/ProtoIntegerType;ZZ)J", "getProtoId", "(J)I", "integerType", "getIntegerType", "(J)Lkotlinx/serialization/protobuf/ProtoIntegerType;", "isPackable", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Z", "isPacked", "(J)Z", "isOneOf", "overrideId", "(JI)J", "extractParameters", "index", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)J", "extractProtoId", "descriptor", "zeroBasedDefault", "getAllOneOfSerializerOfField", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getActualOneOfSerializer", "kotlinx-serialization-protobuf"})
@SourceDebugExtension(value={"SMAP\nHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n28#1,3:134\n33#1:143\n2642#2:137\n2632#2,3:139\n1#3:138\n1#3:142\n*S KotlinDebug\n*F\n+ 1 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n*L\n85#1:134,3\n131#1:143\n120#1:137\n121#1:139,3\n120#1:138\n*E\n"})
public final class HelpersKt {
    public static final int VARINT = 0;
    public static final int i64 = 1;
    public static final int SIZE_DELIMITED = 2;
    public static final int i32 = 5;
    public static final int ID_HOLDER_ONE_OF = -2;
    private static final long ONEOFMASK = 0x1000000000L;
    private static final long INTTYPEMASK = 0x600000000L;
    private static final long PACKEDMASK = 0x100000000L;

    public static final long ProtoDesc(int protoId, @NotNull ProtoIntegerType type, boolean packed, boolean oneOf) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        boolean $i$f$ProtoDesc = false;
        long packedBits = packed ? 0x100000000L : 0L;
        long oneOfBits = oneOf ? 0x1000000000L : 0L;
        return packedBits | oneOfBits | type.getSignature$kotlinx_serialization_protobuf() | (long)protoId;
    }

    public static /* synthetic */ long ProtoDesc$default(int protoId, ProtoIntegerType type, boolean packed, boolean oneOf, int n, Object object) {
        if ((n & 4) != 0) {
            packed = false;
        }
        if ((n & 8) != 0) {
            oneOf = false;
        }
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        boolean $i$f$ProtoDesc = false;
        long packedBits = packed ? 0x100000000L : 0L;
        long oneOfBits = oneOf ? 0x1000000000L : 0L;
        return packedBits | oneOfBits | type.getSignature$kotlinx_serialization_protobuf() | (long)protoId;
    }

    public static final int getProtoId(long $this$protoId) {
        boolean $i$f$getProtoId = false;
        return (int)($this$protoId & Integer.MAX_VALUE);
    }

    @NotNull
    public static final ProtoIntegerType getIntegerType(long $this$integerType) {
        long l = $this$integerType & 0x600000000L;
        return l == ProtoIntegerType.DEFAULT.getSignature$kotlinx_serialization_protobuf() ? ProtoIntegerType.DEFAULT : (l == ProtoIntegerType.SIGNED.getSignature$kotlinx_serialization_protobuf() ? ProtoIntegerType.SIGNED : ProtoIntegerType.FIXED);
    }

    public static final boolean isPackable(@NotNull SerialDescriptor $this$isPackable) {
        Intrinsics.checkNotNullParameter((Object)$this$isPackable, (String)"<this>");
        SerialKind serialKind = $this$isPackable.getKind();
        return !Intrinsics.areEqual((Object)serialKind, (Object)PrimitiveKind.STRING.INSTANCE) && serialKind instanceof PrimitiveKind;
    }

    public static final boolean isPacked(long $this$isPacked) {
        return ($this$isPacked & 0x100000000L) != 0L;
    }

    public static final boolean isOneOf(long $this$isOneOf) {
        return ($this$isOneOf & 0x1000000000L) != 0L;
    }

    public static final long overrideId(long $this$overrideId, int protoId) {
        return $this$overrideId & 0xFFFFFFF00000000L | (long)protoId;
    }

    public static final long extractParameters(@NotNull SerialDescriptor $this$extractParameters, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$extractParameters, (String)"<this>");
        List annotations = $this$extractParameters.getElementAnnotations(index);
        int protoId = index + 1;
        ProtoIntegerType format = ProtoIntegerType.DEFAULT;
        boolean protoPacked = false;
        boolean isOneOf = false;
        int n = ((Collection)annotations).size();
        for (int i = 0; i < n; ++i) {
            Annotation annotation = (Annotation)annotations.get(i);
            if (annotation instanceof ProtoNumber) {
                protoId = ((ProtoNumber)annotation).number();
                continue;
            }
            if (annotation instanceof ProtoType) {
                format = ((ProtoType)annotation).type();
                continue;
            }
            if (annotation instanceof ProtoPacked) {
                protoPacked = true;
                continue;
            }
            if (!(annotation instanceof ProtoOneOf)) continue;
            isOneOf = true;
        }
        if (isOneOf) {
            protoId = index + 1;
        }
        boolean $i$f$ProtoDesc = false;
        long packedBits$iv = protoPacked ? 0x100000000L : 0L;
        long oneOfBits$iv = isOneOf ? 0x1000000000L : 0L;
        return packedBits$iv | oneOfBits$iv | format.getSignature$kotlinx_serialization_protobuf() | (long)protoId;
    }

    public static final int extractProtoId(@NotNull SerialDescriptor descriptor, int index, boolean zeroBasedDefault) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        List annotations = descriptor.getElementAnnotations(index);
        int result = zeroBasedDefault ? index : index + 1;
        int n = ((Collection)annotations).size();
        for (int i = 0; i < n; ++i) {
            Annotation annotation = (Annotation)annotations.get(i);
            if (annotation instanceof ProtoOneOf) {
                return -2;
            }
            if (!(annotation instanceof ProtoNumber)) continue;
            result = ((ProtoNumber)annotation).number();
        }
        return result;
    }

    @NotNull
    public static final List<SerialDescriptor> getAllOneOfSerializerOfField(@NotNull SerialDescriptor $this$getAllOneOfSerializerOfField, @NotNull SerializersModule serializersModule) {
        Iterable iterable;
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$getAllOneOfSerializerOfField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        SerialKind serialKind = $this$getAllOneOfSerializerOfField.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.OPEN.INSTANCE)) {
            list = ContextAwareKt.getPolymorphicDescriptors((SerializersModule)serializersModule, (SerialDescriptor)$this$getAllOneOfSerializerOfField);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.SEALED.INSTANCE)) {
            list = CollectionsKt.toList((Iterable)SerialDescriptorKt.getElementDescriptors((SerialDescriptor)$this$getAllOneOfSerializerOfField.getElementDescriptor(1)));
        } else {
            throw new IllegalArgumentException("Class " + $this$getAllOneOfSerializerOfField.getSerialName() + " should be abstract or sealed or interface to be used as @ProtoOneOf property.");
        }
        Iterable $this$onEach$iv = list;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2419$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
            boolean bl2;
            SerialDescriptor desc;
            block8: {
                desc = (SerialDescriptor)element$iv;
                boolean bl3 = false;
                Iterable $this$none$iv = desc.getElementAnnotations(0);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        Annotation anno = (Annotation)element$iv2;
                        boolean bl4 = false;
                        if (!(anno instanceof ProtoNumber)) continue;
                        bl2 = false;
                        break block8;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            throw new IllegalArgumentException(desc.getSerialName() + " implementing oneOf type " + $this$getAllOneOfSerializerOfField.getSerialName() + " should have @ProtoNumber annotation in its single property.");
        }
        return (List)iterable;
    }

    @Nullable
    public static final SerialDescriptor getActualOneOfSerializer(@NotNull SerialDescriptor $this$getActualOneOfSerializer, @NotNull SerializersModule serializersModule, int protoId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getActualOneOfSerializer, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
            Iterable iterable = HelpersKt.getAllOneOfSerializerOfField($this$getActualOneOfSerializer, serializersModule);
            for (Object t : iterable) {
                SerialDescriptor it = (SerialDescriptor)t;
                boolean bl = false;
                long $this$protoId$iv = HelpersKt.extractParameters(it, 0);
                boolean $i$f$getProtoId = false;
                if (!((int)($this$protoId$iv & Integer.MAX_VALUE) == protoId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

