/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.aggregate;

import com.intellij.rt.coverage.aggregate.InheritanceFilter;
import com.intellij.rt.coverage.aggregate.api.Request;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.instrument.RawReportLoader;
import com.intellij.rt.coverage.instrumentation.InstrumentationOptions;
import com.intellij.rt.coverage.instrumentation.UnloadedUtil;
import com.intellij.rt.coverage.instrumentation.data.ProjectContext;
import com.intellij.rt.coverage.report.data.BinaryReport;
import com.intellij.rt.coverage.util.CoverageReport;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import com.intellij.rt.coverage.util.classFinder.ClassFilter;
import com.intellij.rt.coverage.util.classFinder.OutputClassFinder;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class Aggregator {
    private final List<BinaryReport> myReports;
    private final List<File> myOutputs;
    private final List<Request> myRequests;

    public Aggregator(List<BinaryReport> reports, List<File> outputRoots, List<Request> requests) {
        this.myReports = reports;
        this.myOutputs = outputRoots;
        this.myRequests = requests;
    }

    public Aggregator(List<BinaryReport> reports, List<File> outputRoots, Request request) {
        this(reports, outputRoots, Collections.singletonList(request));
    }

    public ProjectData getProjectData(Request request) {
        boolean hasRawHitsReport = false;
        for (BinaryReport report : this.myReports) {
            hasRawHitsReport |= report.isRawHitsReport();
        }
        ProjectData projectData = new ProjectData();
        ProjectContext context = this.collectCoverageInformationFromOutputs(projectData, request);
        ProjectData projectDataCopy = hasRawHitsReport ? Aggregator.copyProjectData(projectData) : null;
        context.dropLineMappings(projectData);
        for (BinaryReport report : this.myReports) {
            if (report.isRawHitsReport()) {
                try {
                    RawReportLoader.load(report.getDataFile(), projectDataCopy);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ProjectData data = ProjectDataLoader.load(report.getDataFile());
            context.dropIgnoredLines(data);
            Aggregator.mergeHits(projectData, data);
        }
        if (projectDataCopy != null) {
            context.finalizeCoverage(projectDataCopy);
            Aggregator.mergeHits(projectData, projectDataCopy);
        }
        if (context.getInherits() != null) {
            projectData = Aggregator.filterInheritance(request, context, projectData);
        }
        return projectData;
    }

    private static ProjectData filterInheritance(Request request, ProjectContext context, ProjectData projectData) {
        InheritanceFilter filter = new InheritanceFilter(context.getInherits());
        List<String> filteredNames = filter.filterInherits(projectData.getClasses().keySet(), request.filters.includeInherits, request.filters.excludeInherits);
        ProjectData copy = new ProjectData();
        for (String className : filteredNames) {
            ClassData classData;
            if (!request.classFilter.shouldInclude(className) || (classData = projectData.getClassData(className)) == null) continue;
            copy.addClassData(classData);
        }
        return copy;
    }

    private static ProjectData copyProjectData(ProjectData projectData) {
        ProjectData projectDataCopy = new ProjectData();
        for (ClassData classData : projectData.getClassesCollection()) {
            ClassData classCopy = projectDataCopy.getOrCreateClassData(classData.getName());
            LineData[] lines = (LineData[])classData.getLines();
            if (lines == null) continue;
            LineData[] linesCopy = new LineData[lines.length];
            classCopy.setLines(linesCopy);
            for (LineData lineData : lines) {
                SwitchData[] switches;
                if (lineData == null) continue;
                LineData lineCopy = new LineData(lineData.getLineNumber(), lineData.getMethodSignature());
                lineCopy.setId(lineData.getId());
                linesCopy[lineCopy.getLineNumber()] = lineCopy;
                JumpData[] jumps = lineData.getJumps();
                if (jumps != null) {
                    for (int i = 0; i < jumps.length; ++i) {
                        JumpData jump = jumps[i];
                        JumpData jumpCopy = lineCopy.addJump(i);
                        jumpCopy.setId(jump.getId(true), true);
                        jumpCopy.setId(jump.getId(false), false);
                    }
                }
                if ((switches = lineData.getSwitches()) != null) {
                    for (int i = 0; i < switches.length; ++i) {
                        SwitchData aSwitch = switches[i];
                        SwitchData switchCopy = lineCopy.addSwitch(i, aSwitch.getKeys());
                        for (int key = -1; key < aSwitch.getKeys().length; ++key) {
                            switchCopy.setId(aSwitch.getId(key), key);
                        }
                    }
                }
                lineCopy.fillArrays();
            }
        }
        return projectDataCopy;
    }

    private static void mergeHits(ProjectData dst, ProjectData src) {
        for (ClassData srcClass : src.getClassesCollection()) {
            ClassData dstClass = dst.getClassData(srcClass.getName());
            if (dstClass == null) continue;
            dstClass.merge(srcClass);
        }
    }

    public void processRequests() {
        for (Request request : this.myRequests) {
            if (request.outputFile == null) continue;
            ProjectData projectData = this.getProjectData(request);
            InstrumentationOptions options = new InstrumentationOptions.Builder().setDataFile(request.outputFile).setSourceMapFile(request.smapFile).build();
            CoverageReport.save(projectData, options);
        }
    }

    private ProjectContext collectCoverageInformationFromOutputs(ProjectData projectData, Request request) {
        projectData.setInstructionsCoverage(true);
        InstrumentationOptions options = new InstrumentationOptions.Builder().setBranchCoverage(true).setSaveSource(true).setInstructionCoverage(true).setIncludeAnnotations(request.filters.includeAnnotations).setExcludeAnnotations(request.filters.excludeAnnotations).build();
        boolean collectInherits = request.filters.shouldCheckInherits();
        ClassFilter.PatternFilter classFilter = collectInherits ? null : request.classFilter;
        ProjectContext context = new ProjectContext(options, new OutputClassFinder(classFilter, this.myOutputs));
        context.setCollectInherits(collectInherits);
        UnloadedUtil.appendUnloaded(projectData, context);
        return context;
    }
}

