/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.aggregate;

import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class InheritanceFilter {
    private final Map<String, IncludeStatus> myStatus = new HashMap<String, IncludeStatus>();
    private final Map<String, String[]> myInherits;

    public InheritanceFilter(Map<String, String[]> inherits) {
        this.myInherits = inherits;
    }

    public List<String> filterInherits(Collection<String> classes, List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        ArrayList<String> result = new ArrayList<String>();
        this.myStatus.clear();
        for (String className : classes) {
            IncludeStatus status = this.isIncluded(className, includePatterns, excludePatterns);
            if (status != IncludeStatus.INCLUDED && status != IncludeStatus.EXCLUDED_SELF && (status != IncludeStatus.UNKNOWN || !includePatterns.isEmpty())) continue;
            result.add(className);
        }
        this.myStatus.clear();
        return result;
    }

    private IncludeStatus isIncluded(String className, List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        IncludeStatus status = this.myStatus.get(className);
        if (status != null) {
            return status;
        }
        status = this.isIncludedInternal(className, includePatterns, excludePatterns);
        this.myStatus.put(className, status);
        return status;
    }

    private IncludeStatus isIncludedInternal(String className, List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        String[] inherits;
        IncludeStatus status = IncludeStatus.UNKNOWN;
        if (ClassNameUtil.matchesPatterns(className, includePatterns)) {
            status = IncludeStatus.INCLUDED_SELF;
        }
        if (ClassNameUtil.matchesPatterns(className, excludePatterns)) {
            status = IncludeStatus.EXCLUDED_SELF;
        }
        if ((inherits = this.myInherits.get(className)) != null) {
            for (String inherit : inherits) {
                IncludeStatus inheritStatus = this.isIncluded(inherit, includePatterns, excludePatterns);
                if (inheritStatus == IncludeStatus.EXCLUDED || inheritStatus == IncludeStatus.EXCLUDED_SELF) {
                    return IncludeStatus.EXCLUDED;
                }
                if (inheritStatus != IncludeStatus.INCLUDED && inheritStatus != IncludeStatus.INCLUDED_SELF || status == IncludeStatus.INCLUDED_SELF || status == IncludeStatus.EXCLUDED_SELF) continue;
                status = IncludeStatus.INCLUDED;
            }
        }
        return status;
    }

    static enum IncludeStatus {
        INCLUDED,
        EXCLUDED,
        INCLUDED_SELF,
        EXCLUDED_SELF,
        UNKNOWN;

    }
}

