/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.BranchData;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.JumpsAndSwitches;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.DataOutputStream;
import java.io.IOException;

public class LineData
implements CoverageData {
    private final int myLineNumber;
    private String myMethodSignature;
    private int myId = -1;
    private int myHits = 0;
    private byte myStatus = (byte)-1;
    private String myUniqueTestName = null;
    private boolean myMayBeUnique = true;
    private JumpsAndSwitches myJumpsAndSwitches;

    /*
     * WARNING - void declaration
     */
    public LineData(int line, String desc) {
        void var2_2;
        void var1_1;
        this.myLineNumber = var1_1;
        this.myMethodSignature = var2_2;
    }

    public void touch() {
        ++this.myHits;
    }

    public int getHits() {
        return this.myHits;
    }

    JumpsAndSwitches getOrCreateJumpsAndSwitches() {
        if (this.myJumpsAndSwitches == null) {
            this.myJumpsAndSwitches = new JumpsAndSwitches();
        }
        return this.myJumpsAndSwitches;
    }

    /*
     * WARNING - void declaration
     */
    public void setJumpsAndSwitches(JumpsAndSwitches jumpsAndSwitches) {
        void var1_1;
        this.myJumpsAndSwitches = var1_1;
    }

    public int getStatus() {
        if (this.myStatus != -1) {
            return this.myStatus;
        }
        if (this.myHits == 0) {
            this.myStatus = 0;
            return this.myStatus;
        }
        if (this.myJumpsAndSwitches != null) {
            SwitchData[] switches;
            JumpData[] jumps = this.getOrCreateJumpsAndSwitches().getJumps();
            if (jumps != null) {
                for (JumpData jumpData : jumps) {
                    if ((jumpData.getFalseHits() > 0 ? 1 : 0) + (jumpData.getTrueHits() > 0 ? 1 : 0) >= 2) continue;
                    this.myStatus = 1;
                    return this.myStatus;
                }
            }
            if ((switches = this.getOrCreateJumpsAndSwitches().getSwitches()) != null) {
                SwitchData[] switchDataArray = switches;
                int n = switches.length;
                for (int i = 0; i < n; ++i) {
                    SwitchData switchData = switchDataArray[i];
                    if (switchData.getDefaultHits() == 0) {
                        this.myStatus = 1;
                        return this.myStatus;
                    }
                    for (int i2 = 0; i2 < switchData.getHits().length; ++i2) {
                        int n2 = switchData.getHits()[i2];
                        if (n2 != 0) continue;
                        this.myStatus = 1;
                        return this.myStatus;
                    }
                }
            }
        }
        this.myStatus = (byte)2;
        return this.myStatus;
    }

    /*
     * WARNING - void declaration
     */
    public void save(DataOutputStream os) throws IOException {
        CoverageIOUtil.writeINT(os, this.myLineNumber);
        CoverageIOUtil.writeUTF(os, this.myUniqueTestName != null ? this.myUniqueTestName : "");
        CoverageIOUtil.writeINT(os, this.myHits);
        if (this.myHits > 0) {
            void var1_1;
            if (this.myJumpsAndSwitches != null) {
                this.getOrCreateJumpsAndSwitches().save(os);
                return;
            }
            new JumpsAndSwitches().save((DataOutputStream)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void merge(CoverageData data) {
        byte status;
        LineData lineData = (LineData)data;
        LineData lineData2 = this;
        lineData2.setHits(lineData2.myHits + lineData.getHits());
        if (lineData.myId != -1) {
            this.myId = lineData.myId;
        }
        if (this.myJumpsAndSwitches != null || lineData.myJumpsAndSwitches != null) {
            this.getOrCreateJumpsAndSwitches().merge(lineData.getOrCreateJumpsAndSwitches());
        }
        if (this.myMethodSignature == null) {
            this.myMethodSignature = lineData.myMethodSignature;
        }
        if (this.myStatus != -1 && (status = (byte)lineData.getStatus()) > this.myStatus) {
            void var1_2;
            this.myStatus = var1_2;
        }
    }

    public int jumpsCount() {
        if (this.myJumpsAndSwitches == null) {
            return 0;
        }
        return this.myJumpsAndSwitches.jumpsCount();
    }

    public int switchesCount() {
        if (this.myJumpsAndSwitches == null) {
            return 0;
        }
        return this.myJumpsAndSwitches.switchesCount();
    }

    /*
     * WARNING - void declaration
     */
    public JumpData addJump(int jump) {
        void var1_1;
        return this.getOrCreateJumpsAndSwitches().addJump((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JumpData getJumpData(int jump) {
        void var1_1;
        return this.getOrCreateJumpsAndSwitches().getJumpData((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public SwitchData addSwitch(int switchNumber, int[] keys2) {
        void var2_2;
        void var1_1;
        return this.getOrCreateJumpsAndSwitches().addSwitch((int)var1_1, (int[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void removeSwitch(int switchNumber) {
        void var1_1;
        this.getOrCreateJumpsAndSwitches().removeSwitch((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public SwitchData getSwitchData(int switchNumber) {
        void var1_1;
        return this.getOrCreateJumpsAndSwitches().getSwitchData((int)var1_1);
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    public String getMethodSignature() {
        return this.myMethodSignature;
    }

    /*
     * WARNING - void declaration
     */
    public void setMethodSignature(String methodSignature) {
        void var1_1;
        this.myMethodSignature = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setStatus(byte status) {
        void var1_1;
        this.myStatus = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrueHits(int jumpNumber, int trueHits) {
        void var2_2;
        void var1_1;
        this.addJump((int)var1_1).setTrueHits((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setFalseHits(int jumpNumber, int falseHits) {
        void var2_2;
        void var1_1;
        this.addJump((int)var1_1).setFalseHits((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultHits(int switchNumber, int[] keys2, int defaultHit) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addSwitch((int)var1_1, (int[])var2_2).setDefaultHits((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void setSwitchHits(int switchNumber, int[] keys2, int[] hits) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addSwitch((int)var1_1, keys2).setKeysAndHits((int[])var2_2, (int[])var3_3);
    }

    public JumpData[] getJumps() {
        if (this.myJumpsAndSwitches == null) {
            return null;
        }
        return this.getOrCreateJumpsAndSwitches().getJumps();
    }

    public SwitchData[] getSwitches() {
        if (this.myJumpsAndSwitches == null) {
            return null;
        }
        return this.getOrCreateJumpsAndSwitches().getSwitches();
    }

    /*
     * WARNING - void declaration
     */
    public BranchData getBranchData() {
        void var2_2;
        void var1_1;
        SwitchData[] switchDataArray;
        int n;
        if (this.myJumpsAndSwitches == null) {
            return null;
        }
        int total = 0;
        int covered = 0;
        JumpData[] nArray = this.myJumpsAndSwitches.getJumps();
        if (nArray != null) {
            JumpData[] jumpDataArray = nArray;
            int n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                JumpData jump = jumpDataArray[n];
                total += 2;
                if (jump.getFalseHits() > 0) {
                    ++covered;
                }
                if (jump.getTrueHits() <= 0) continue;
                ++covered;
            }
        }
        if ((switchDataArray = this.myJumpsAndSwitches.getSwitches()) != null) {
            SwitchData[] switchDataArray2 = switchDataArray;
            n = switchDataArray.length;
            for (int i = 0; i < n; ++i) {
                SwitchData switchData = switchDataArray2[i];
                for (int hit : switchData.getHits()) {
                    ++total;
                    if (hit <= 0) continue;
                    ++covered;
                }
            }
        }
        return new BranchData((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setHits(int hits) {
        void var1_1;
        this.myHits = ClassData.trimHits((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setTestName(String testName) {
        if (testName != null) {
            void var1_1;
            if (this.myUniqueTestName == null) {
                if (this.myMayBeUnique) {
                    this.myUniqueTestName = testName;
                    return;
                }
            } else if (!var1_1.equals(this.myUniqueTestName)) {
                this.myUniqueTestName = null;
                this.myMayBeUnique = false;
            }
        }
    }

    public boolean isCoveredByOneTest() {
        return this.myUniqueTestName != null && this.myUniqueTestName.length() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public void removeJump(int jump) {
        void var1_1;
        if (this.myJumpsAndSwitches == null) {
            return;
        }
        this.getOrCreateJumpsAndSwitches().removeJump((int)var1_1);
    }

    public void fillArrays() {
        if (this.myJumpsAndSwitches == null) {
            return;
        }
        this.getOrCreateJumpsAndSwitches().fillArrays();
    }

    public int getId() {
        return this.myId;
    }

    /*
     * WARNING - void declaration
     */
    public void setId(int id) {
        void var1_1;
        this.myId = var1_1;
    }
}

