/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrument;

import com.intellij.rt.coverage.instrument.DirectoryVisitor;
import com.intellij.rt.coverage.instrument.IOUtil;
import com.intellij.rt.coverage.instrument.OfflineCoverageTransformer;
import com.intellij.rt.coverage.instrumentation.CoverageTransformer;
import com.intellij.rt.coverage.instrumentation.InstrumentationOptions;
import com.intellij.rt.coverage.report.api.Filters;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;

public class Instrumentator {
    private final List<File> myRoots;
    private final List<File> myOutputRoots;
    private final Filters myFilters;

    public Instrumentator(List<File> roots, List<File> outputRoots, Filters filters) {
        this.myRoots = roots;
        this.myOutputRoots = outputRoots;
        this.myFilters = filters;
    }

    public void instrument(boolean countHits) {
        for (int i = 0; i < this.myRoots.size(); ++i) {
            File root = this.myRoots.get(i);
            File outputRoot = this.myOutputRoots.get(i);
            new InstrumentationVisitor(root, outputRoot, countHits).visitFiles();
        }
    }

    public static byte[] instrument(byte[] bytes, boolean countHits) {
        InstrumentationOptions options = new InstrumentationOptions.Builder().setIsCalculateHits(countHits).build();
        OfflineCoverageTransformer transformer = new OfflineCoverageTransformer(options);
        String className = new ClassReader(bytes).getClassName();
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        return transformer.transform(loader, className, bytes);
    }

    private class InstrumentationVisitor
    extends DirectoryVisitor {
        private final File myOutput;
        private final CoverageTransformer myTransformer;

        private InstrumentationVisitor(File root, File output, boolean countHits) {
            super(root);
            this.myOutput = output;
            InstrumentationOptions options = new InstrumentationOptions.Builder().setIsCalculateHits(countHits).setExcludeAnnotations(((Instrumentator)Instrumentator.this).myFilters.excludeAnnotations).build();
            this.myTransformer = new OfflineCoverageTransformer(options);
        }

        @Override
        protected void visitFile(String packageName, File file) {
            try {
                File directory;
                byte[] bytes = IOUtil.readBytes(file);
                if (file.getName().endsWith(".class")) {
                    String classSimpleName = ClassNameUtil.removeClassSuffix(file.getName());
                    String className = packageName.isEmpty() ? classSimpleName : ClassNameUtil.convertToInternalName(packageName) + "/" + classSimpleName;
                    ClassLoader loader = ClassLoader.getSystemClassLoader();
                    byte[] transformed = this.myTransformer.transform(loader, className, null, null, bytes);
                    if (transformed != null) {
                        bytes = transformed;
                    }
                }
                if (!(directory = new File(this.myOutput, packageName.replace(".", File.separator))).exists() && !directory.mkdirs()) {
                    throw new RuntimeException("Failed to create directory at " + directory.getAbsolutePath());
                }
                File newFile = new File(directory, file.getName());
                IOUtil.writeBytes(newFile, bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

