/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.CoverageArgs;
import com.intellij.rt.coverage.instrumentation.CoverageRuntime;
import com.intellij.rt.coverage.instrumentation.CoverageTransformer;
import com.intellij.rt.coverage.instrumentation.InstrumentationOptions;
import com.intellij.rt.coverage.instrumentation.data.ProjectContext;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingArrayMode;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingClassDataMode;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingMode;
import com.intellij.rt.coverage.util.CoverageReport;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.OptionsUtil;
import com.intellij.rt.coverage.util.TestTrackingCallback;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instrumentator {
    public static boolean ourIsInitialized = false;

    /*
     * WARNING - void declaration
     */
    public static void premain(String argsString, Instrumentation instrumentation) throws Exception {
        void var1_1;
        String string;
        new Instrumentator().performPremain(string, (Instrumentation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void performPremain(String argsString, Instrumentation instrumentation) throws Exception {
        Class<Instrumentator> clazz = Instrumentator.class;
        synchronized (Instrumentator.class) {
            void var2_4;
            void var1_1;
            CoverageArgs args2;
            if (ourIsInitialized) {
                ErrorReporter.info("Coverage agent has been applied twice, ignore the second one.");
                // ** MonitorExit[var3_5] (shouldn't be in output)
                return;
            }
            ourIsInitialized = true;
            // ** MonitorExit[var3_5] (shouldn't be in output)
            try {
                args2 = CoverageArgs.fromString(argsString);
            }
            catch (IllegalArgumentException e) {
                ErrorReporter.error("Failed to parse agent arguments", e);
                System.exit(1);
                return;
            }
            ErrorReporter.printInfo("---- IntelliJ IDEA coverage runner ---- ");
            ErrorReporter.printInfo((args2.branchCoverage ? "Branch coverage " : "Line coverage ") + (args2.testTracking ? "with tracking per test coverage ..." : "..."));
            this.logPatterns(args2.includePatterns, "include");
            this.logPatterns(args2.excludePatterns, "exclude");
            this.logPatterns(args2.annotationsToInclude, "include annotations");
            this.logPatterns(args2.annotationsToIgnore, "exclude annotations");
            TestTrackingMode testTrackingMode = this.createTestTrackingMode(args2.testTracking);
            TestTrackingCallback callback = testTrackingMode == null ? null : testTrackingMode.createTestTrackingCallback(args2.dataFile);
            InstrumentationOptions options = new InstrumentationOptions.Builder().setBranchCoverage(args2.branchCoverage).setIsMergeData(args2.mergeData).setIsCalculateUnloaded(args2.calcUnloaded).setInstructionCoverage(OptionsUtil.INSTRUCTIONS_COVERAGE_ENABLED).setIsCalculateHits(OptionsUtil.CALCULATE_HITS_COUNT).setIncludePatterns(args2.includePatterns).setExcludePatterns(args2.excludePatterns).setIncludeAnnotations(args2.annotationsToInclude).setExcludeAnnotations(args2.annotationsToIgnore).setDataFile(args2.dataFile).setSourceMapFile(args2.sourceMap).setTestTrackingMode(testTrackingMode).build();
            this.createDataFile(args2.dataFile);
            ProjectData data = new ProjectData(callback);
            CoverageRuntime.installRuntime(data);
            ProjectContext instrumentationData = new ProjectContext(options);
            CoverageTransformer transformer = new CoverageTransformer(data, instrumentationData);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this, transformer, (ProjectData)((Object)clazz), (ProjectContext)var1_1){
                final /* synthetic */ CoverageTransformer val$transformer;
                final /* synthetic */ ProjectData val$data;
                final /* synthetic */ ProjectContext val$instrumentationData;
                final /* synthetic */ Instrumentator this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$transformer = coverageTransformer;
                    this.val$data = projectData;
                    this.val$instrumentationData = projectContext;
                }

                public void run() {
                    this.val$transformer.stop();
                    CoverageReport.save(this.val$data, this.val$instrumentationData);
                }
            }));
            this.addTransformer((Instrumentation)var2_4, transformer);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createDataFile(File dataFile) throws IOException {
        if (dataFile != null && !dataFile.exists()) {
            void var1_1;
            File parentDir = dataFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                void var2_2;
                var2_2.mkdirs();
            }
            var1_1.createNewFile();
        }
    }

    private void logPatterns(List<Pattern> patterns, String name) {
        Iterator iterator2;
        Pattern pattern;
        if (patterns.isEmpty()) {
            return;
        }
        ErrorReporter.printInfo((String)((Object)pattern) + " patterns:");
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            pattern = (Pattern)iterator2.next();
            ErrorReporter.printInfo(pattern.pattern());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addTransformer(Instrumentation instrumentation, CoverageTransformer transformer) {
        try {
            Method method = Instrumentation.class.getMethod("addTransformer", ClassFileTransformer.class, Boolean.TYPE);
            method.invoke((Object)instrumentation, transformer, Boolean.TRUE);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            void var2_2;
            void var1_1;
            var1_1.addTransformer((ClassFileTransformer)var2_2);
            return;
        }
        catch (Exception e) {
            void var3_4;
            ErrorReporter.error("Adding transformer failed.", (Throwable)var3_4);
            System.exit(1);
            return;
        }
    }

    private TestTrackingMode createTestTrackingMode(boolean traceLines) {
        if (!traceLines) {
            return null;
        }
        if (OptionsUtil.NEW_TEST_TRACKING_ENABLED) {
            return new TestTrackingArrayMode();
        }
        return new TestTrackingClassDataMode();
    }
}

