/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class ClosingBracesFilter
extends CoverageFilter {
    private boolean myHasInstructions;
    private int myCurrentLine = -1;
    private boolean mySeenReturn;
    private boolean mySeenGoto;
    private int myLinesCount = 0;

    private void tryRemoveLine() {
        if (this.myCurrentLine != -1 && (this.mySeenReturn || this.mySeenGoto) && !this.myHasInstructions && this.myLinesCount > 1) {
            this.myContext.removeLine(this.myCurrentLine);
            --this.myLinesCount;
            this.myCurrentLine = -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitLineNumber(int line, Label start) {
        void var2_2;
        void var1_1;
        this.tryRemoveLine();
        if (this.myCurrentLine != line) {
            ++this.myLinesCount;
        }
        this.myCurrentLine = this.myContext.getLineData(line) == null ? line : -1;
        this.myHasInstructions = false;
        this.mySeenReturn = false;
        this.mySeenGoto = false;
        super.visitLineNumber((int)var1_1, (Label)var2_2);
    }

    public void visitEnd() {
        this.tryRemoveLine();
        super.visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    public void visitInsn(int opcode) {
        void var1_1;
        super.visitInsn(opcode);
        if (this.myCurrentLine == -1) {
            return;
        }
        if (172 <= opcode && opcode <= 177) {
            this.mySeenReturn = true;
            return;
        }
        if (var1_1 == 87) {
            return;
        }
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitTableSwitchInsn((int)var1_1, (int)var2_2, (Label)var3_3, labels);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitLookupSwitchInsn((Label)var1_1, (int[])var2_2, (Label[])var3_3);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        void var1_1;
        void var2_2;
        super.visitJumpInsn(opcode, (Label)var2_2);
        if (var1_1 == 167) {
            this.mySeenGoto = true;
            return;
        }
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitLdcInsn(Object value) {
        void var1_1;
        super.visitLdcInsn(var1_1);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitIincInsn(int var, int increment) {
        void var2_2;
        void var1_1;
        super.visitIincInsn((int)var1_1, (int)var2_2);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitIntInsn(int opcode, int operand) {
        void var2_2;
        void var1_1;
        super.visitIntInsn((int)var1_1, (int)var2_2);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        void var2_2;
        void var1_1;
        super.visitMultiANewArrayInsn((String)var1_1, (int)var2_2);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitTypeInsn(int opcode, String type) {
        void var2_2;
        void var1_1;
        super.visitTypeInsn((int)var1_1, (String)var2_2);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitFieldInsn(opcode, owner, name, descriptor);
        if (var1_1 == 178 && var2_2.equals("kotlin/Unit") && var3_3.equals("INSTANCE") && descriptor.equals("Lkotlin/Unit;")) {
            return;
        }
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitVarInsn(int opcode, int var) {
        void var2_2;
        void var1_1;
        super.visitVarInsn((int)var1_1, (int)var2_2);
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitMethodInsn((int)var1_1, (String)var2_2, (String)var3_3, descriptor, isInterface);
        this.setHasInstructions();
    }

    private void setHasInstructions() {
        this.myHasInstructions |= !this.mySeenReturn && this.myCurrentLine != -1;
    }

    public boolean isApplicable(InstrumentationData context) {
        return true;
    }
}

