/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinDefaultArgsBranchFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.Type;

public class KotlinCoroutinesFilter
extends CoverageFilter {
    private boolean myGetCoroutinesSuspendedVisited = false;
    private boolean myStoreCoroutinesSuspendedVisited = false;
    private boolean myLoadCoroutinesSuspendedVisited = false;
    private boolean myLoadStateLabelVisited = false;
    private boolean mySuspendCallVisited = false;
    private int myCoroutinesSuspendedIndex = -1;
    private int myLine = -1;
    private boolean myHadLineDataBefore = false;
    private int myState = 0;
    private boolean myHasInstructions;

    /*
     * WARNING - void declaration
     */
    public boolean isApplicable(InstrumentationData context) {
        void var1_1;
        return KotlinUtils.isKotlinClass(context) && (context.getMethodName().equals("invokeSuspend") || var1_1.getMethodDesc().endsWith("Lkotlin/coroutines/Continuation;)Ljava/lang/Object;"));
    }

    /*
     * WARNING - void declaration
     */
    public void visitLineNumber(int line, Label start) {
        void var1_1;
        void var2_2;
        this.myHadLineDataBefore = this.myContext.getLineData(line) != null;
        super.visitLineNumber(line, (Label)var2_2);
        this.myLine = var1_1;
        this.myHasInstructions = false;
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        void var1_1;
        void var3_3;
        void var2_2;
        boolean suspendCallVisited;
        String desc;
        int index;
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        if (this.myState == 3 && opcode == 183 && "java/lang/IllegalStateException".equals(owner) && "<init>".equals(name) && "(Ljava/lang/String;)V".equals(descriptor)) {
            this.myState = 4;
        } else {
            this.myState = 0;
            this.myHasInstructions = true;
        }
        boolean getCoroutinesSuspendedVisited = opcode == 184 && owner.equals("kotlin/coroutines/intrinsics/IntrinsicsKt") && name.equals("getCOROUTINE_SUSPENDED") && descriptor.equals("()Ljava/lang/Object;");
        String originalDesc = descriptor;
        if (name.endsWith("$default") && (index = (desc = KotlinDefaultArgsBranchFilter.getOriginalNameAndDesc(name, descriptor)).indexOf(40)) > 0) {
            originalDesc = desc.substring(index);
        }
        boolean bl = suspendCallVisited = originalDesc.endsWith("Lkotlin/coroutines/Continuation;)Ljava/lang/Object;") || var2_2.startsWith("kotlin/jvm/functions/Function") && var3_3.equals("invoke") && var1_1 == 185 && descriptor.endsWith(")Ljava/lang/Object;");
        if (getCoroutinesSuspendedVisited || suspendCallVisited) {
            this.myGetCoroutinesSuspendedVisited |= getCoroutinesSuspendedVisited;
            this.mySuspendCallVisited |= suspendCallVisited;
            return;
        }
        this.myGetCoroutinesSuspendedVisited = false;
        this.mySuspendCallVisited = false;
    }

    /*
     * WARNING - void declaration
     */
    public void visitVarInsn(int opcode, int var) {
        void var2_2;
        void var1_1;
        super.visitVarInsn(opcode, var);
        this.myHasInstructions = true;
        if (!this.myStoreCoroutinesSuspendedVisited && this.myGetCoroutinesSuspendedVisited && opcode == 58) {
            this.myStoreCoroutinesSuspendedVisited = true;
            this.myCoroutinesSuspendedIndex = var;
        }
        this.myLoadCoroutinesSuspendedVisited = this.myStoreCoroutinesSuspendedVisited && var1_1 == 25 && var2_2 == this.myCoroutinesSuspendedIndex;
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        void var1_1;
        void var2_2;
        super.visitJumpInsn(opcode, (Label)var2_2);
        this.myHasInstructions = true;
        boolean bl = this.myLoadCoroutinesSuspendedVisited || this.myGetCoroutinesSuspendedVisited;
        if (bl && this.mySuspendCallVisited && var1_1 == 166) {
            this.myContext.removeLastJump();
            this.mySuspendCallVisited = false;
        }
        this.myLoadCoroutinesSuspendedVisited = false;
    }

    /*
     * WARNING - void declaration
     */
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        void var1_1;
        void var2_3;
        void var3_4;
        super.visitFieldInsn(opcode, owner, name, descriptor);
        this.myHasInstructions = true;
        boolean labelVisited = var3_4.equals("label") && descriptor.equals("I") && Type.getObjectType(owner).getClassName().startsWith(this.myContext.get(Key.CLASS_NAME));
        this.myLoadStateLabelVisited = var2_3 != false && var1_1 == 180;
    }

    /*
     * WARNING - void declaration
     */
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitTableSwitchInsn((int)var1_1, (int)var2_2, (Label)var3_3, labels);
        this.myHasInstructions = true;
        if (this.myLoadStateLabelVisited) {
            this.myContext.removeLastSwitch();
            if (!this.myHadLineDataBefore) {
                KotlinCoroutinesFilter kotlinCoroutinesFilter = this;
                kotlinCoroutinesFilter.onIgnoredLine(kotlinCoroutinesFilter.myLine);
            }
        }
        this.myLoadStateLabelVisited = false;
    }

    /*
     * WARNING - void declaration
     */
    public void visitInsn(int opcode) {
        void var1_1;
        super.visitInsn(opcode);
        if (this.myState == 1 && opcode == 89) {
            this.myState = 2;
            return;
        }
        if (this.myState == 4 && opcode == 191) {
            if (!this.myHadLineDataBefore && !this.myHasInstructions) {
                KotlinCoroutinesFilter kotlinCoroutinesFilter = this;
                kotlinCoroutinesFilter.onIgnoredLine(kotlinCoroutinesFilter.myLine);
            }
            return;
        }
        this.myHasInstructions = true;
        this.myState = 0;
        if (var1_1 == 176 && this.myLoadCoroutinesSuspendedVisited && !this.myHadLineDataBefore) {
            KotlinCoroutinesFilter kotlinCoroutinesFilter = this;
            kotlinCoroutinesFilter.onIgnoredLine(kotlinCoroutinesFilter.myLine);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitTypeInsn(int opcode, String type) {
        void var2_2;
        void var1_1;
        super.visitTypeInsn(opcode, type);
        if (var1_1 == 187 && "java/lang/IllegalStateException".equals(var2_2)) {
            this.myState = 1;
            return;
        }
        this.myHasInstructions = true;
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLdcInsn(Object value) {
        void var1_1;
        super.visitLdcInsn(value);
        if (this.myState == 2 && "call to 'resume' before 'invoke' with coroutine".equals(var1_1)) {
            this.myState = 3;
            return;
        }
        this.myHasInstructions = true;
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitLookupSwitchInsn((Label)var1_1, (int[])var2_2, (Label[])var3_3);
        this.myHasInstructions = true;
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitIincInsn(int var, int increment) {
        void var2_2;
        void var1_1;
        super.visitIincInsn((int)var1_1, (int)var2_2);
        this.myHasInstructions = true;
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitIntInsn(int opcode, int operand) {
        void var2_2;
        void var1_1;
        super.visitIntInsn((int)var1_1, (int)var2_2);
        this.myHasInstructions = true;
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        void var2_2;
        void var1_1;
        super.visitMultiANewArrayInsn((String)var1_1, (int)var2_2);
        this.myHasInstructions = true;
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    private void onIgnoredLine(int line) {
        void var1_1;
        this.myContext.removeLine((int)var1_1);
    }
}

