/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.branches.KotlinDefaultArgsBranchFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import com.intellij.rt.coverage.instrumentation.filters.lines.KotlinImplementerDefaultInterfaceMemberFilter;
import org.jetbrains.coverage.org.objectweb.asm.Handle;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class KotlinDefaultArgsLineFilter
extends CoverageFilter {
    private int myFirstLine = -1;
    private int myCurrentLine = -1;
    private int myState = 0;
    private boolean myHasInstructions = false;
    private String myName;
    private String myNameDesc;
    private String myInternalName;
    private int myMaxMaskIndex = -1;
    private int myMinMaskIndex = -1;

    public boolean isApplicable(InstrumentationData context) {
        return KotlinDefaultArgsBranchFilter.isFilterApplicable(context);
    }

    /*
     * WARNING - void declaration
     */
    public void initFilter(MethodVisitor methodVisitor, InstrumentationData context) {
        void var1_1;
        void var2_2;
        super.initFilter(methodVisitor, context);
        String name = context.getMethodName();
        String desc = context.getMethodDesc();
        this.myNameDesc = KotlinDefaultArgsBranchFilter.getOriginalNameAndDesc(name, desc);
        this.myName = this.myNameDesc.substring(0, this.myNameDesc.indexOf(40));
        this.myInternalName = KotlinImplementerDefaultInterfaceMemberFilter.removeDefaultMarkerSuffix(this.myContext.get(Key.CLASS_INTERNAL_NAME));
        int[] range = KotlinDefaultArgsBranchFilter.getMaskIndexRange(name, (String)var2_2);
        this.myMinMaskIndex = range[0];
        this.myMaxMaskIndex = var1_1[1];
        this.myHasInstructions = false;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLineNumber(int line, Label start) {
        void var2_3;
        if (this.myFirstLine == -1) {
            this.myFirstLine = line;
        }
        this.myCurrentLine = line;
        super.visitLineNumber(line, (Label)var2_3);
        LineData lineData = this.myContext.getLineData(line);
        if (lineData != null) {
            void var1_2;
            var1_2.setMethodSignature(this.myNameDesc);
        }
    }

    public void visitEnd() {
        if (this.myFirstLine != -1 && !this.myHasInstructions) {
            this.myContext.removeLine(this.myFirstLine);
        }
        super.visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    public void visitVarInsn(int opcode, int var) {
        void var2_2;
        void var1_1;
        super.visitVarInsn((int)var1_1, var);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        if ((this.myState == 0 || this.myState == 4) && this.myMinMaskIndex <= var && var <= this.myMaxMaskIndex) {
            this.myState = 1;
            return;
        }
        if ((this.myState == 4 || this.myState == 10) && var2_2 < this.myMinMaskIndex) {
            this.myState = 10;
            return;
        }
        this.markHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitInsn(int opcode) {
        void var1_1;
        super.visitInsn(opcode);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        if (this.myState == 2 && opcode == 126) {
            this.myState = 3;
            return;
        }
        if (this.myState == 1 && (opcode == 4 || opcode == 5 || opcode == 7)) {
            this.myState = 2;
            return;
        }
        if (this.myState == 11 && 172 <= opcode && var1_1 <= 177) {
            return;
        }
        this.markHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitIntInsn(int opcode, int operand) {
        void var1_1;
        void var2_2;
        super.visitIntInsn(opcode, (int)var2_2);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        if (this.myState == 1 && (opcode == 16 || var1_1 == 17)) {
            this.myState = 2;
            return;
        }
        this.markHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitLdcInsn(Object value) {
        void var1_1;
        super.visitLdcInsn(value);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        if (this.myState == 1 && var1_1 instanceof Integer) {
            this.myState = 2;
            return;
        }
        this.markHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        void var1_1;
        void var2_2;
        super.visitJumpInsn(opcode, (Label)var2_2);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        if (this.myState == 3 && var1_1 == 153) {
            this.myState = 4;
            return;
        }
        this.markHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        void var2_2;
        void var3_3;
        void var1_1;
        super.visitMethodInsn((int)var1_1, owner, name, descriptor, isInterface);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        if (this.myState == 10 && this.myName.equals(var3_3) && this.myInternalName.equals(var2_2)) {
            this.myState = 11;
            return;
        }
        this.markHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitFieldInsn((int)var1_1, (String)var2_2, (String)var3_3, descriptor);
        this.markHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitIincInsn(int var, int increment) {
        void var2_2;
        void var1_1;
        super.visitIincInsn((int)var1_1, (int)var2_2);
        this.markHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitLookupSwitchInsn((Label)var1_1, (int[])var2_2, (Label[])var3_3);
        this.markHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        void var2_2;
        void var1_1;
        super.visitMultiANewArrayInsn((String)var1_1, (int)var2_2);
        this.markHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitTableSwitchInsn((int)var1_1, (int)var2_2, (Label)var3_3, labels);
        this.markHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitTypeInsn(int opcode, String type) {
        void var2_2;
        void var1_1;
        super.visitTypeInsn((int)var1_1, (String)var2_2);
        this.markHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitInvokeDynamicInsn((String)var1_1, (String)var2_2, (Handle)var3_3, bootstrapMethodArguments);
        this.markHasInstructions();
    }

    private void markHasInstructions() {
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        if (this.myState < 4) {
            return;
        }
        this.myHasInstructions = true;
    }
}

