/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.report;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.report.util.FileLocator;
import com.intellij.rt.coverage.report.util.FileUtils;
import com.intellij.rt.coverage.report.util.SourceFileLocator;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import jetbrains.coverage.report.SourceCodeProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectorySourceCodeProvider
implements SourceCodeProvider {
    private final FileLocator myFileLocator;

    public DirectorySourceCodeProvider(ProjectData projectData, List<File> sources) {
        this.myFileLocator = new SourceFileLocator(sources, projectData);
    }

    private static String readText(File file) {
        try {
            return FileUtils.readAll(file);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public CharSequence getSourceCode(@NotNull String className) {
        List<File> candidates = this.myFileLocator.locate(className);
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return DirectorySourceCodeProvider.readText(candidates.get(0));
        }
        int packageIndex = className.lastIndexOf(46);
        String packageName = packageIndex == -1 ? ".*" : className.substring(0, packageIndex).replace(".", "\\.");
        Pattern pattern = Pattern.compile("package +" + packageName);
        String lastCandidateText = null;
        for (File candidate : candidates) {
            boolean matchFound;
            String text = DirectorySourceCodeProvider.readText(candidate);
            if (text == null) continue;
            if (packageIndex != -1 != (matchFound = pattern.matcher(lastCandidateText = text).find())) continue;
            return lastCandidateText;
        }
        return lastCandidateText;
    }
}

