/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.report;

import com.intellij.rt.coverage.aggregate.Aggregator;
import com.intellij.rt.coverage.aggregate.api.Request;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.report.api.Filters;
import com.intellij.rt.coverage.report.data.BinaryReport;
import java.io.File;
import java.util.List;

public abstract class ReportLoadStrategy {
    protected final List<BinaryReport> myReports;
    protected final List<File> myOutputRoots;
    protected final List<File> mySourceRoots;
    private ProjectData myCacheData;

    protected ReportLoadStrategy(List<BinaryReport> reports, List<File> outputRoots, List<File> sourceRoots) {
        this.myReports = reports;
        this.myOutputRoots = outputRoots;
        this.mySourceRoots = sourceRoots;
    }

    public ProjectData getProjectData() {
        if (this.myCacheData == null) {
            this.myCacheData = this.loadProjectData();
        }
        return this.myCacheData;
    }

    protected abstract ProjectData loadProjectData();

    public List<File> getSources() {
        return this.mySourceRoots;
    }

    public static class AggregatedReportLoadStrategy
    extends ReportLoadStrategy {
        protected AggregatedReportLoadStrategy(List<BinaryReport> reports, List<File> outputRoots, List<File> sourceRoots) {
            super(reports, outputRoots, sourceRoots);
            if (reports.size() != 1) {
                throw new IllegalArgumentException("One aggregated report expected, but " + reports.size() + " reports found.");
            }
        }

        @Override
        protected ProjectData loadProjectData() {
            return ((BinaryReport)this.myReports.get(0)).loadData();
        }
    }

    public static class RawReportLoadStrategy
    extends ReportLoadStrategy {
        private final Filters myFilters;

        public RawReportLoadStrategy(List<BinaryReport> reports, List<File> outputRoots, List<File> sourceRoots, Filters filters) {
            super(reports, outputRoots, sourceRoots);
            this.myFilters = filters;
        }

        @Override
        protected ProjectData loadProjectData() {
            Request request = new Request(this.myFilters, null, null);
            Aggregator aggregator = new Aggregator((List<BinaryReport>)this.myReports, (List<File>)this.myOutputRoots, request);
            return aggregator.getProjectData(request);
        }
    }
}

