/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.report.api;

import com.intellij.rt.coverage.report.ReportLoadStrategy;
import com.intellij.rt.coverage.report.Reporter;
import com.intellij.rt.coverage.report.api.Filters;
import com.intellij.rt.coverage.report.data.BinaryReport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jetbrains.coverage.report.impl.IOUtil;
import org.jetbrains.annotations.Nullable;

public class ReportApi {
    private ReportApi() {
    }

    public static void xmlReport(File xmlReportFile, String title, List<File> reports, List<File> outputRoots, List<File> sourceRoots, Filters filters) throws IOException {
        Reporter reporter = ReportApi.createReporter(title, reports, outputRoots, sourceRoots, filters);
        reporter.createXMLReport(xmlReportFile);
    }

    public static void htmlReport(File htmlReportDir, @Nullable String title, @Nullable String charset, List<File> reports, List<File> outputRoots, List<File> sourceRoots, Filters filters) throws IOException {
        Reporter reporter = ReportApi.createReporter(title, reports, outputRoots, sourceRoots, filters);
        reporter.createHTMLReport(htmlReportDir, charset);
    }

    private static Reporter createReporter(String title, List<File> reports, List<File> outputRoots, List<File> sourceRoots, Filters filters) {
        ArrayList<BinaryReport> binaryReports = new ArrayList<BinaryReport>();
        for (File report : reports) {
            binaryReports.add(new BinaryReport(report, null));
        }
        ReportLoadStrategy.RawReportLoadStrategy loadStrategy = new ReportLoadStrategy.RawReportLoadStrategy(binaryReports, outputRoots, sourceRoots, filters);
        return new Reporter(loadStrategy, title);
    }

    public static void setFreemarkerRetry(int repeatMaxCount, long repeatCooldownMs) {
        IOUtil.repeatMaxCount = repeatMaxCount;
        IOUtil.repeatCooldownMs = repeatCooldownMs;
    }
}

