/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.report.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class FileLocator {
    protected final List<File> myRoots;

    public FileLocator(List<File> roots) {
        this.myRoots = roots;
    }

    public abstract List<File> locate(String var1);

    protected List<File> locateFile(String packageName, String fileName) {
        String path = FileLocator.getPath(packageName, fileName);
        ArrayList<File> result = new ArrayList<File>();
        for (File f : this.myRoots) {
            File candidate = new File(f, path);
            if (!candidate.exists() || !candidate.isFile()) continue;
            result.add(candidate);
        }
        return result;
    }

    private static String getPath(String packageName, String name) {
        if (packageName.isEmpty()) {
            return name;
        }
        packageName = packageName.replace('.', File.separatorChar);
        return packageName + File.separatorChar + name;
    }
}

