/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.verify;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.report.XMLCoverageReport;
import com.intellij.rt.coverage.verify.ProjectTargetProcessor;
import com.intellij.rt.coverage.verify.TargetProcessor;
import com.intellij.rt.coverage.verify.Verifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PackageTargetProcessor
implements TargetProcessor {
    @Override
    public void process(ProjectData projectData, TargetProcessor.Consumer consumer) {
        HashMap<String, List<ClassData>> classesToPackages = XMLCoverageReport.mapClassesToPackages(projectData, false);
        for (Map.Entry packageEntry : classesToPackages.entrySet()) {
            Verifier.CollectedCoverage packageCoverage = new Verifier.CollectedCoverage();
            for (ClassData classData : (List)packageEntry.getValue()) {
                Verifier.CollectedCoverage coverage = ProjectTargetProcessor.collectClassCoverage(projectData, classData);
                packageCoverage.add(coverage);
            }
            String packageName = (String)packageEntry.getKey();
            consumer.consume(packageName, packageCoverage);
        }
    }
}

