/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.verify;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import com.intellij.rt.coverage.verify.TargetProcessor;
import com.intellij.rt.coverage.verify.api.Bound;
import com.intellij.rt.coverage.verify.api.BoundViolation;
import com.intellij.rt.coverage.verify.api.Rule;
import com.intellij.rt.coverage.verify.api.RuleViolation;
import com.intellij.rt.coverage.verify.api.Violation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Verifier {
    private final List<Rule> myRules;

    public Verifier(List<Rule> rules) {
        this.myRules = rules;
    }

    public List<RuleViolation> processRules() {
        ArrayList<RuleViolation> violations = new ArrayList<RuleViolation>();
        for (Rule rule : this.myRules) {
            RuleViolation violation = Verifier.processRule(rule);
            if (violation == null) continue;
            violations.add(violation);
        }
        return violations;
    }

    private static RuleViolation processRule(final Rule rule) {
        ProjectData projectData = ProjectDataLoader.load(rule.reportFile);
        final HashMap violations = new HashMap();
        TargetProcessor processor = rule.target.createTargetProcessor();
        processor.process(projectData, new TargetProcessor.Consumer(){

            private BoundViolation getOrCreateViolation(int boundId) {
                BoundViolation violation = (BoundViolation)violations.get(boundId);
                if (violation == null) {
                    violation = new BoundViolation(boundId);
                    violations.put(boundId, violation);
                }
                return violation;
            }

            @Override
            public void consume(String name, CollectedCoverage coverage) {
                for (Bound bound : rule.bounds) {
                    BoundViolation violation;
                    BigDecimal value = bound.valueType.getValue(bound.counter.getCounter(coverage));
                    if (value == null) continue;
                    if (bound.min != null && value.compareTo(bound.min) < 0) {
                        violation = this.getOrCreateViolation(bound.id);
                        violation.minViolations.add(new Violation(name, value));
                    }
                    if (bound.max == null || value.compareTo(bound.max) <= 0) continue;
                    violation = this.getOrCreateViolation(bound.id);
                    violation.maxViolations.add(new Violation(name, value));
                }
            }
        });
        if (violations.isEmpty()) {
            return null;
        }
        return new RuleViolation(rule.id, new ArrayList<BoundViolation>(violations.values()));
    }

    public static class CollectedCoverage {
        public final Counter lineCounter = new Counter();
        public final Counter instructionCounter = new Counter();
        public final Counter branchCounter = new Counter();

        public void add(CollectedCoverage other) {
            this.lineCounter.add(other.lineCounter);
            this.instructionCounter.add(other.instructionCounter);
            this.branchCounter.add(other.branchCounter);
        }

        public static class Counter {
            public long missed = 0L;
            public long covered = 0L;

            public void add(Counter other) {
                this.missed += other.missed;
                this.covered += other.covered;
            }
        }
    }
}

