/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.cli.commands;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.cli.commands.Command;
import kotlinx.kover.features.jvm.ClassFilters;
import kotlinx.kover.features.jvm.KoverLegacyFeatures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkotlinx/kover/cli/commands/OfflineInstrumentCommand;", "Lkotlinx/kover/cli/commands/Command;", "()V", "countHits", "", "description", "", "getDescription", "()Ljava/lang/String;", "excludeAnnotation", "", "excludeClasses", "includeClasses", "name", "getName", "outputDir", "Ljava/io/File;", "roots", "call", "", "output", "Ljava/io/PrintWriter;", "errorWriter", "kover-cli"})
public final class OfflineInstrumentCommand
implements Command {
    @Argument(usage="list of the compiled class-files roots", metaVar="<class-file-path>", required=true)
    @NotNull
    private List<File> roots = new ArrayList();
    @Option(name="--dest", usage="path to write instrumented Java classes to", metaVar="<dir>", required=true)
    @Nullable
    private File outputDir;
    @Option(name="--hits", usage="a flag to enable line hits counting")
    private boolean countHits;
    @Option(name="--include", usage="instrument only specified classes, wildcards `*` and `?` are acceptable", metaVar="<class-name>")
    @NotNull
    private List<String> includeClasses = new ArrayList();
    @Option(name="--exclude", usage="filter to exclude classes from instrumentation, wildcards `*` and `?` are acceptable. Excludes have priority over includes", metaVar="<class-name>")
    @NotNull
    private List<String> excludeClasses = new ArrayList();
    @Option(name="--excludeAnnotation", usage="filter to exclude annotated classes from instrumentation, wildcards `*` and `?` are acceptable", metaVar="<annotation-name>")
    @NotNull
    private List<String> excludeAnnotation = new ArrayList();
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public OfflineInstrumentCommand() {
        this.name = "instrument";
        this.description = "Offline instrumentation of JVM class-files";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public int call(@NotNull PrintWriter output, @NotNull PrintWriter errorWriter) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(errorWriter, "errorWriter");
        ClassFilters filters = new ClassFilters(CollectionsKt.toSet((Iterable)this.includeClasses), CollectionsKt.toSet((Iterable)this.excludeClasses), CollectionsKt.toSet((Iterable)this.excludeAnnotation), SetsKt.emptySet(), SetsKt.emptySet(), SetsKt.emptySet());
        try {
            File file = this.outputDir;
            Intrinsics.checkNotNull(file);
            KoverLegacyFeatures.INSTANCE.instrument(file, this.roots, filters, this.countHits);
        }
        catch (Exception e) {
            errorWriter.println("Instrumentation failed: " + e.getMessage());
            return -1;
        }
        return 0;
    }
}

