/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.cli.commands;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.cli.commands.Command;
import kotlinx.kover.features.jvm.ClassFilters;
import kotlinx.kover.features.jvm.KoverLegacyFeatures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkotlinx/kover/cli/commands/ReportCommand;", "Lkotlinx/kover/cli/commands/Command;", "()V", "binaryReports", "", "Ljava/io/File;", "description", "", "getDescription", "()Ljava/lang/String;", "excludeAnnotation", "excludeClasses", "excludeInheritedFrom", "htmlDir", "includeAnnotation", "includeClasses", "includeInheritedFrom", "name", "getName", "outputRoots", "sourceRoots", "title", "xmlFile", "call", "", "output", "Ljava/io/PrintWriter;", "errorWriter", "kover-cli"})
public final class ReportCommand
implements Command {
    @Argument(usage="list of binary reports files", metaVar="<binary-report-path>")
    @NotNull
    private List<File> binaryReports = new ArrayList();
    @Option(name="--src", usage="location of the source files root", metaVar="<sources-path>", required=true)
    @NotNull
    private List<File> sourceRoots = new ArrayList();
    @Option(name="--classfiles", usage="location of the compiled class-files root (must be original and not instrumented)", metaVar="<class-file-path>", required=true)
    @NotNull
    private List<File> outputRoots = new ArrayList();
    @Option(name="--xml", usage="generate a XML report in the specified path", metaVar="<xml-file-path>")
    @Nullable
    private File xmlFile;
    @Option(name="--html", usage="generate a HTML report in the specified path", metaVar="<html-dir>")
    @Nullable
    private File htmlDir;
    @Option(name="--title", usage="title in the HTML or XML report", metaVar="<title>")
    @Nullable
    private String title;
    @Option(name="--include", usage="filter to include classes, wildcards `*` and `?` are acceptable", metaVar="<class-name>")
    @NotNull
    private List<String> includeClasses = new ArrayList();
    @Option(name="--exclude", usage="filter to exclude classes, wildcards `*` and `?` are acceptable", metaVar="<class-name>")
    @NotNull
    private List<String> excludeClasses = new ArrayList();
    @Option(name="--excludeAnnotation", usage="filter to exclude classes and functions marked by this annotation, wildcards `*` and `?` are acceptable. Excludes have priority over includes", metaVar="<exclude-annotation-name>")
    @NotNull
    private List<String> excludeAnnotation = new ArrayList();
    @Option(name="--includeAnnotation", usage="filter to include classes marked by this annotation, wildcards `*` and `?` are acceptable. Excludes have priority over includes.", metaVar="<include-annotation-name>")
    @NotNull
    private List<String> includeAnnotation = new ArrayList();
    @Option(name="--excludeInheritedFrom", usage="filter to exclude classes extending the specified class or implementing an interface, wildcards `*` and `?` are acceptable. Excludes have priority over includes", metaVar="<exclude-ancestor-name>")
    @NotNull
    private List<String> excludeInheritedFrom = new ArrayList();
    @Option(name="--includeInheritedFrom", usage="filter to include only classes extending the specified class or implementing an interface, wildcards `*` and `?` are acceptable. Excludes have priority over includes", metaVar="<include-ancestor-name>")
    @NotNull
    private List<String> includeInheritedFrom = new ArrayList();
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public ReportCommand() {
        this.name = "report";
        this.description = "Generates human-readable reports in various formats from binary report files";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public int call(@NotNull PrintWriter output, @NotNull PrintWriter errorWriter) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(errorWriter, "errorWriter");
        ClassFilters filters = new ClassFilters(CollectionsKt.toSet((Iterable)this.includeClasses), CollectionsKt.toSet((Iterable)this.excludeClasses), CollectionsKt.toSet((Iterable)this.includeAnnotation), CollectionsKt.toSet((Iterable)this.excludeAnnotation), CollectionsKt.toSet((Iterable)this.includeInheritedFrom), CollectionsKt.toSet((Iterable)this.excludeInheritedFrom));
        boolean fail = false;
        if (this.xmlFile != null) {
            try {
                File file = this.xmlFile;
                Intrinsics.checkNotNull(file);
                String string = this.title;
                if (string == null) {
                    string = "Kover XML Report";
                }
                KoverLegacyFeatures.INSTANCE.generateXmlReport(file, this.binaryReports, this.outputRoots, this.sourceRoots, string, filters);
            }
            catch (IOException e) {
                fail = true;
                errorWriter.println("XML generation failed: " + e.getMessage());
            }
        }
        if (this.htmlDir != null) {
            try {
                File file = this.htmlDir;
                Intrinsics.checkNotNull(file);
                String string = this.title;
                if (string == null) {
                    string = "Kover HTML Report";
                }
                KoverLegacyFeatures.INSTANCE.generateHtmlReport(file, null, this.binaryReports, this.outputRoots, this.sourceRoots, string, filters);
            }
            catch (IOException e) {
                fail = true;
                errorWriter.println("HTML generation failed: " + e.getMessage());
            }
        }
        if (this.xmlFile == null && this.htmlDir == null) {
            errorWriter.println("At least one format must be used: XML, HTML.");
            fail = true;
        }
        return fail ? -1 : 0;
    }
}

