/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.cli.commands;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.cli.commands.Command;
import kotlinx.kover.cli.commands.CommandParser;
import kotlinx.kover.cli.commands.OfflineInstrumentCommand;
import kotlinx.kover.cli.commands.ReportCommand;
import kotlinx.kover.cli.commands.RootCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lkotlinx/kover/cli/commands/RootCommand;", "Lkotlinx/kover/cli/commands/Command;", "()V", "command", "description", "", "getDescription", "()Ljava/lang/String;", "name", "getName", "call", "", "output", "Ljava/io/PrintWriter;", "errorWriter", "Companion", "RootHandler", "kover-cli"})
public final class RootCommand
implements Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Argument(required=true, handler=RootHandler.class)
    @Nullable
    private Command command;
    @Nullable
    private final String name;
    @NotNull
    private final String description;
    @NotNull
    private static final List<Command> commands;

    public RootCommand() {
        this.description = "Command line interface for Kover - Kotlin Coverage Toolset";
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public int call(@NotNull PrintWriter output, @NotNull PrintWriter errorWriter) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(errorWriter, "errorWriter");
        Command command = this.command;
        return command != null ? command.call(output, errorWriter) : 0;
    }

    static {
        Command[] commandArray = new Command[]{new OfflineInstrumentCommand(), new ReportCommand()};
        commands = CollectionsKt.listOf(commandArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lkotlinx/kover/cli/commands/RootCommand$Companion;", "", "()V", "commands", "", "Lkotlinx/kover/cli/commands/Command;", "getCommands", "()Ljava/util/List;", "joinedCommandNames", "", "kover-cli"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Command> getCommands() {
            return commands;
        }

        private final String joinedCommandNames() {
            return CollectionsKt.joinToString$default(this.getCommands(), " | ", null, null, 0, null, joinedCommandNames.1.INSTANCE, 30, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0010\u0010\u0007\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0002\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lkotlinx/kover/cli/commands/RootCommand$RootHandler;", "Lorg/kohsuke/args4j/spi/OptionHandler;", "Lkotlinx/kover/cli/commands/Command;", "parser", "Lorg/kohsuke/args4j/CmdLineParser;", "option", "Lorg/kohsuke/args4j/OptionDef;", "setter", "Lorg/kohsuke/args4j/spi/Setter;", "(Lorg/kohsuke/args4j/CmdLineParser;Lorg/kohsuke/args4j/OptionDef;Lorg/kohsuke/args4j/spi/Setter;)V", "getDefaultMetaVariable", "", "parseArguments", "", "params", "Lorg/kohsuke/args4j/spi/Parameters;", "kover-cli"})
    public static final class RootHandler
    extends OptionHandler<Command> {
        public RootHandler(@Nullable CmdLineParser parser, @NotNull OptionDef option, @Nullable Setter<? super Command> setter) {
            Intrinsics.checkNotNullParameter(option, "option");
            String string = Companion.joinedCommandNames();
            boolean bl = option.required();
            boolean bl2 = option.help();
            boolean bl3 = option.hidden();
            Class<RootHandler> clazz = RootHandler.class;
            boolean bl4 = option.isMultiValued();
            super(parser, new OptionDef(string, bl, bl2, bl3, clazz, bl4){}, setter);
        }

        @Override
        public int parseArguments(@NotNull Parameters params) {
            Intrinsics.checkNotNullParameter(params, "params");
            String invokedCommand = params.getParameter(0);
            for (Command command : Companion.getCommands()) {
                if (!Intrinsics.areEqual(command.getName(), invokedCommand)) continue;
                ArrayList<String> args2 = new ArrayList<String>();
                int n = params.size();
                for (int i = 1; i < n; ++i) {
                    args2.add(params.getParameter(i));
                }
                CommandParser parser = new CommandParser(command);
                parser.parseArgument((Collection<String>)args2);
                this.setter.addValue(command);
                return params.size();
            }
            String[] stringArray = new String[]{this.option.toString(), invokedCommand};
            throw new CmdLineException(this.owner, Messages.ILLEGAL_OPERAND, stringArray);
        }

        @Override
        @NotNull
        public String getDefaultMetaVariable() {
            return "<command>";
        }
    }
}

