/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.features.jvm.impl;

import com.intellij.rt.coverage.instrument.api.OfflineInstrumentationApi;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.features.jvm.KoverFeatures;
import kotlinx.kover.features.jvm.OfflineInstrumenter;
import kotlinx.kover.features.jvm.impl.ConDySettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lkotlinx/kover/features/jvm/impl/OfflineInstrumenterImpl;", "Lkotlinx/kover/features/jvm/OfflineInstrumenter;", "countHits", "", "(Z)V", "instrument", "", "originalClass", "Ljava/io/InputStream;", "debugName", "", "kover-features-jvm"})
public final class OfflineInstrumenterImpl
implements OfflineInstrumenter {
    private final boolean countHits;

    public OfflineInstrumenterImpl(boolean countHits) {
        this.countHits = countHits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] instrument(@NotNull InputStream originalClass, @NotNull String debugName) {
        Intrinsics.checkNotNullParameter(originalClass, "originalClass");
        Intrinsics.checkNotNullParameter(debugName, "debugName");
        String previousConDySetting = ConDySettings.INSTANCE.disableConDy();
        try {
            byte[] byArray = OfflineInstrumentationApi.instrument(originalClass, this.countHits);
            Intrinsics.checkNotNullExpressionValue(byArray, "instrument(originalClass, countHits)");
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Throwable e) {
            String string = "Error while instrumenting '%s' with Kover instrumenter version '%s'";
            Object[] objectArray = new Object[]{debugName, KoverFeatures.INSTANCE.getVersion()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            throw new IOException(string2, e);
        }
        finally {
            ConDySettings.INSTANCE.restoreConDy(previousConDySetting);
        }
    }
}

