/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.features.jvm;

import com.intellij.rt.coverage.instrument.api.OfflineInstrumentationApi;
import com.intellij.rt.coverage.report.api.Filters;
import com.intellij.rt.coverage.report.api.ReportApi;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlinx.kover.features.jvm.ConDySettings;

public class KoverLegacyFeatures {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void instrument(File resultDir, List<File> originalDirs, ClassFilters filters, boolean countHits) {
        ArrayList<File> outputs = new ArrayList<File>(originalDirs.size());
        for (int i = 0; i < originalDirs.size(); ++i) {
            outputs.add(resultDir);
        }
        String previousConDySetting = ConDySettings.disableConDy();
        try {
            OfflineInstrumentationApi.instrument(originalDirs, outputs, (Filters)KoverLegacyFeatures.convertFilters(filters), (boolean)countHits);
        }
        finally {
            ConDySettings.restoreConDy(previousConDySetting);
        }
    }

    public static void generateXmlReport(File xmlFile, List<File> binaryReports, List<File> classfileDirs, List<File> sourceDirs, String title, ClassFilters filters) throws IOException {
        ReportApi.xmlReport((File)xmlFile, (String)title, binaryReports, classfileDirs, sourceDirs, (Filters)KoverLegacyFeatures.convertFilters(filters));
    }

    public static void generateHtmlReport(File htmlDir, List<File> binaryReports, List<File> classfileDirs, List<File> sourceDirs, String title, ClassFilters filters) throws IOException {
        ReportApi.htmlReport((File)htmlDir, (String)title, null, binaryReports, classfileDirs, sourceDirs, (Filters)KoverLegacyFeatures.convertFilters(filters));
    }

    private static Filters convertFilters(ClassFilters filters) {
        return new Filters(KoverLegacyFeatures.convert(filters.includeClasses), KoverLegacyFeatures.convert(filters.excludeClasses), KoverLegacyFeatures.convert(filters.excludeAnnotation));
    }

    private static List<Pattern> convert(Set<String> regexes) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(regexes.size());
        for (String regex : regexes) {
            patterns.add(Pattern.compile(regex));
        }
        return patterns;
    }

    public static class ClassFilters {
        public final Set<String> includeClasses;
        public final Set<String> excludeClasses;
        public final Set<String> excludeAnnotation;

        public ClassFilters(Set<String> includeClasses, Set<String> excludeClasses, Set<String> excludeAnnotation) {
            this.includeClasses = includeClasses;
            this.excludeClasses = excludeClasses;
            this.excludeAnnotation = excludeAnnotation;
        }
    }
}

