/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.features.jvm;

import com.intellij.rt.coverage.instrument.api.OfflineInstrumentationApi;
import java.io.IOException;
import java.io.InputStream;
import kotlinx.kover.features.jvm.ConDySettings;
import kotlinx.kover.features.jvm.KoverFeatures;
import kotlinx.kover.features.jvm.OfflineInstrumenter;

class OfflineInstrumenterImpl
implements OfflineInstrumenter {
    private final boolean countHits;

    OfflineInstrumenterImpl(boolean countHits) {
        this.countHits = countHits;
    }

    @Override
    public byte[] instrument(InputStream originalClass, String debugName) throws IOException {
        String previousConDySetting = ConDySettings.disableConDy();
        try {
            byte[] byArray = OfflineInstrumentationApi.instrument((InputStream)originalClass, (boolean)this.countHits);
            return byArray;
        }
        catch (Throwable e) {
            throw new IOException(String.format("Error while instrumenting '%s' with Kover instrumenter version '%s'", debugName, KoverFeatures.getVersion()), e);
        }
        finally {
            ConDySettings.restoreConDy(previousConDySetting);
        }
    }
}

