/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.features.jvm;

import com.intellij.rt.coverage.aggregate.api.AggregatorApi;
import com.intellij.rt.coverage.aggregate.api.Request;
import com.intellij.rt.coverage.instrument.api.OfflineInstrumentationApi;
import com.intellij.rt.coverage.report.api.Filters;
import com.intellij.rt.coverage.report.api.ReportApi;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.kover.features.jvm.AggregationType;
import kotlinx.kover.features.jvm.Bound;
import kotlinx.kover.features.jvm.BoundViolation;
import kotlinx.kover.features.jvm.ClassFilters;
import kotlinx.kover.features.jvm.CoverageUnit;
import kotlinx.kover.features.jvm.CoverageValue;
import kotlinx.kover.features.jvm.GroupingBy;
import kotlinx.kover.features.jvm.KoverLegacyFeaturesKt;
import kotlinx.kover.features.jvm.Rule;
import kotlinx.kover.features.jvm.RuleViolations;
import kotlinx.kover.features.jvm.impl.ConDySettings;
import kotlinx.kover.features.jvm.impl.LegacyVerification;
import kotlinx.kover.features.jvm.impl.WildcardsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\rJP\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\rJR\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJH\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ.\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\b2\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"J\u001c\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rJF\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\r2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\rJ\u0014\u0010(\u001a\u00020\u00042\f\u0010)\u001a\b\u0012\u0004\u0012\u00020%0\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lkotlinx/kover/features/jvm/KoverLegacyFeatures;", "", "()V", "FREE_MARKER_LOGGER_PROPERTY_NAME", "", "aggregateIc", "", "icFile", "Ljava/io/File;", "filters", "Lkotlinx/kover/features/jvm/ClassFilters;", "tempDir", "binaryReports", "", "classfileDirs", "evalCoverage", "Lkotlinx/kover/features/jvm/CoverageValue;", "groupBy", "Lkotlinx/kover/features/jvm/GroupingBy;", "coverageUnit", "Lkotlinx/kover/features/jvm/CoverageUnit;", "aggregationForGroup", "Lkotlinx/kover/features/jvm/AggregationType;", "generateHtmlReport", "htmlDir", "charsetName", "sourceDirs", "title", "generateXmlReport", "xmlFile", "instrument", "resultDir", "originalDirs", "countHits", "", "mergeIc", "verify", "Lkotlinx/kover/features/jvm/RuleViolations;", "rules", "Lkotlinx/kover/features/jvm/Rule;", "violationMessage", "violations", "kover-features-jvm"})
@SourceDebugExtension(value={"SMAP\nKoverLegacyFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoverLegacyFeatures.kt\nkotlinx/kover/features/jvm/KoverLegacyFeatures\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,316:1\n1869#2:317\n1563#2:318\n1634#2,3:319\n1869#2,2:322\n1870#2:324\n*S KotlinDebug\n*F\n+ 1 KoverLegacyFeatures.kt\nkotlinx/kover/features/jvm/KoverLegacyFeatures\n*L\n203#1:317\n210#1:318\n210#1:319,3\n212#1:322,2\n203#1:324\n*E\n"})
public final class KoverLegacyFeatures {
    @NotNull
    public static final KoverLegacyFeatures INSTANCE = new KoverLegacyFeatures();
    @NotNull
    private static final String FREE_MARKER_LOGGER_PROPERTY_NAME = "org.freemarker.loggerLibrary";

    private KoverLegacyFeatures() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void instrument(@NotNull File resultDir, @NotNull List<? extends File> originalDirs, @NotNull ClassFilters filters, boolean countHits) {
        Intrinsics.checkNotNullParameter((Object)resultDir, (String)"resultDir");
        Intrinsics.checkNotNullParameter(originalDirs, (String)"originalDirs");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        ArrayList<File> outputs = new ArrayList<File>(originalDirs.size());
        int n = ((Collection)originalDirs).size();
        for (int i = 0; i < n; ++i) {
            outputs.add(resultDir);
        }
        String previousConDySetting = ConDySettings.INSTANCE.disableConDy();
        try {
            OfflineInstrumentationApi.instrument(originalDirs, (List)outputs, (Filters)WildcardsKt.convert(filters), (boolean)countHits);
        }
        finally {
            ConDySettings.INSTANCE.restoreConDy(previousConDySetting);
        }
    }

    public final void generateXmlReport(@NotNull File xmlFile, @NotNull List<? extends File> binaryReports, @NotNull List<? extends File> classfileDirs, @NotNull List<? extends File> sourceDirs, @NotNull String title, @NotNull ClassFilters filters) throws IOException {
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Intrinsics.checkNotNullParameter(binaryReports, (String)"binaryReports");
        Intrinsics.checkNotNullParameter(classfileDirs, (String)"classfileDirs");
        Intrinsics.checkNotNullParameter(sourceDirs, (String)"sourceDirs");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        ReportApi.xmlReport((File)xmlFile, (String)title, binaryReports, classfileDirs, sourceDirs, (Filters)WildcardsKt.convert(filters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateHtmlReport(@NotNull File htmlDir, @Nullable String charsetName, @NotNull List<? extends File> binaryReports, @NotNull List<? extends File> classfileDirs, @NotNull List<? extends File> sourceDirs, @NotNull String title, @NotNull ClassFilters filters) throws IOException {
        Intrinsics.checkNotNullParameter((Object)htmlDir, (String)"htmlDir");
        Intrinsics.checkNotNullParameter(binaryReports, (String)"binaryReports");
        Intrinsics.checkNotNullParameter(classfileDirs, (String)"classfileDirs");
        Intrinsics.checkNotNullParameter(sourceDirs, (String)"sourceDirs");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        ErrorReporter.setLogLevel((int)3);
        String oldFreemarkerLogger = System.setProperty(FREE_MARKER_LOGGER_PROPERTY_NAME, "none");
        try {
            ReportApi.htmlReport((File)htmlDir, (String)title, (String)charsetName, binaryReports, classfileDirs, sourceDirs, (Filters)WildcardsKt.convert(filters));
        }
        finally {
            if (oldFreemarkerLogger == null) {
                System.clearProperty(FREE_MARKER_LOGGER_PROPERTY_NAME);
            } else {
                System.setProperty(FREE_MARKER_LOGGER_PROPERTY_NAME, oldFreemarkerLogger);
            }
        }
    }

    @NotNull
    public final List<RuleViolations> verify(@NotNull List<Rule> rules, @NotNull File tempDir, @NotNull ClassFilters filters, @NotNull List<? extends File> binaryReports, @NotNull List<? extends File> classfileDirs) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter(binaryReports, (String)"binaryReports");
        Intrinsics.checkNotNullParameter(classfileDirs, (String)"classfileDirs");
        try {
            return LegacyVerification.INSTANCE.verify(rules, tempDir, filters, binaryReports, classfileDirs);
        }
        catch (IOException e) {
            throw new RuntimeException("Kover features exception occurred while verification", e);
        }
    }

    public final void aggregateIc(@NotNull File icFile, @NotNull ClassFilters filters, @NotNull File tempDir, @NotNull List<? extends File> binaryReports, @NotNull List<? extends File> classfileDirs) {
        Intrinsics.checkNotNullParameter((Object)icFile, (String)"icFile");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter(binaryReports, (String)"binaryReports");
        Intrinsics.checkNotNullParameter(classfileDirs, (String)"classfileDirs");
        File smapFile = FilesKt.resolve((File)tempDir, (String)"report.smap");
        Request request = new Request(WildcardsKt.convert(filters), icFile, smapFile);
        AggregatorApi.aggregate((List)CollectionsKt.listOf((Object)request), binaryReports, classfileDirs);
    }

    public final void mergeIc(@NotNull File icFile, @NotNull List<? extends File> binaryReports) {
        Intrinsics.checkNotNullParameter((Object)icFile, (String)"icFile");
        Intrinsics.checkNotNullParameter(binaryReports, (String)"binaryReports");
        AggregatorApi.merge(binaryReports, (File)icFile);
    }

    @NotNull
    public final List<CoverageValue> evalCoverage(@NotNull GroupingBy groupBy, @NotNull CoverageUnit coverageUnit, @NotNull AggregationType aggregationForGroup, @NotNull File tempDir, @NotNull ClassFilters filters, @NotNull List<? extends File> binaryReports, @NotNull List<? extends File> classfileDirs) {
        Intrinsics.checkNotNullParameter((Object)((Object)groupBy), (String)"groupBy");
        Intrinsics.checkNotNullParameter((Object)((Object)coverageUnit), (String)"coverageUnit");
        Intrinsics.checkNotNullParameter((Object)((Object)aggregationForGroup), (String)"aggregationForGroup");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter(binaryReports, (String)"binaryReports");
        Intrinsics.checkNotNullParameter(classfileDirs, (String)"classfileDirs");
        Bound bound = new Bound(LegacyVerification.INSTANCE.getONE_HUNDRED$kover_features_jvm(), BigDecimal.ZERO, coverageUnit, aggregationForGroup);
        Rule rule = new Rule("", groupBy, CollectionsKt.listOf((Object)bound));
        List<RuleViolations> violations = this.verify(CollectionsKt.listOf((Object)rule), tempDir, filters, binaryReports, classfileDirs);
        ArrayList<CoverageValue> result = new ArrayList<CoverageValue>();
        for (RuleViolations violation : violations) {
            for (BoundViolation boundViolation : violation.getViolations()) {
                result.add(new CoverageValue(boundViolation.getEntityName(), boundViolation.getValue()));
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String violationMessage(@NotNull List<RuleViolations> violations) {
        Intrinsics.checkNotNullParameter(violations, (String)"violations");
        if (violations.isEmpty()) {
            return "";
        }
        StringBuilder messageBuilder = new StringBuilder();
        Iterable $this$forEach$iv = violations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$mapTo$iv$iv;
            String namedRule;
            RuleViolations rule = (RuleViolations)element$iv;
            boolean bl = false;
            String string = namedRule = ((CharSequence)rule.getRule().getName()).length() > 0 ? "Rule '" + rule.getRule().getName() + '\'' : "Rule";
            if (rule.getViolations().size() == 1) {
                messageBuilder.append(namedRule + " violated: " + KoverLegacyFeaturesKt.access$format(rule.getViolations().get(0), rule)).append('\n');
                continue;
            }
            messageBuilder.append(namedRule + " violated:").append('\n');
            Iterable $this$map$iv = rule.getViolations();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void bound;
                BoundViolation boundViolation = (BoundViolation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(KoverLegacyFeaturesKt.access$format((BoundViolation)bound, rule));
            }
            $this$map$iv = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String boundString = (String)element$iv2;
                boolean bl3 = false;
                messageBuilder.append("  ");
                messageBuilder.append(boundString).append('\n');
            }
        }
        String string = messageBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"messageBuilder.toString()");
        return string;
    }
}

