/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.dsl.internal;

import java.util.Arrays;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.commons.KoverCriticalException;
import kotlinx.kover.gradle.plugin.commons.KoverIllegalConfigException;
import kotlinx.kover.gradle.plugin.dsl.KoverInstrumentationExclusions;
import kotlinx.kover.gradle.plugin.dsl.KoverProjectExtension;
import kotlinx.kover.gradle.plugin.dsl.KoverSourcesExclusions;
import kotlinx.kover.gradle.plugin.dsl.KoverTestsExclusions;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverInstrumentationExclusionsImpl;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverSourcesExclusionsImpl;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverTestsExclusionsImpl;
import kotlinx.kover.gradle.plugin.tools.CoverageToolVariant;
import kotlinx.kover.gradle.plugin.tools.JacocoToolDefaultVariant;
import kotlinx.kover.gradle.plugin.tools.JacocoToolVariant;
import kotlinx.kover.gradle.plugin.tools.KoverToolDefaultVariant;
import kotlinx.kover.gradle.plugin.tools.KoverToolVariant;
import kotlinx.kover.gradle.plugin.util.SemVer;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.kotlin.dsl.ActionExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\u0016\u0010\"\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020#0 H\u0016J\u0016\u0010$\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020%0 H\u0016J\b\u0010&\u001a\u00020\u001eH\u0016J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u001eH\u0016J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lkotlinx/kover/gradle/plugin/dsl/internal/KoverProjectExtensionImpl;", "Lkotlinx/kover/gradle/plugin/dsl/KoverProjectExtension;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "disabledForProject", "", "getDisabledForProject", "()Z", "setDisabledForProject", "(Z)V", "instrumentation", "Lkotlinx/kover/gradle/plugin/dsl/internal/KoverInstrumentationExclusionsImpl;", "getInstrumentation$kover_gradle_plugin", "()Lkotlinx/kover/gradle/plugin/dsl/internal/KoverInstrumentationExclusionsImpl;", "sources", "Lkotlinx/kover/gradle/plugin/dsl/internal/KoverSourcesExclusionsImpl;", "getSources$kover_gradle_plugin", "()Lkotlinx/kover/gradle/plugin/dsl/internal/KoverSourcesExclusionsImpl;", "tests", "Lkotlinx/kover/gradle/plugin/dsl/internal/KoverTestsExclusionsImpl;", "getTests$kover_gradle_plugin", "()Lkotlinx/kover/gradle/plugin/dsl/internal/KoverTestsExclusionsImpl;", "toolVariant", "Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "getToolVariant$kover_gradle_plugin", "()Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "setToolVariant$kover_gradle_plugin", "(Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;)V", "excludeInstrumentation", "", "config", "Lorg/gradle/api/Action;", "Lkotlinx/kover/gradle/plugin/dsl/KoverInstrumentationExclusions;", "excludeSources", "Lkotlinx/kover/gradle/plugin/dsl/KoverSourcesExclusions;", "excludeTests", "Lkotlinx/kover/gradle/plugin/dsl/KoverTestsExclusions;", "useJacocoTool", "version", "", "useKoverTool", "kover-gradle-plugin"})
public class KoverProjectExtensionImpl
implements KoverProjectExtension {
    private boolean disabledForProject;
    @Nullable
    private CoverageToolVariant toolVariant;
    @NotNull
    private final KoverTestsExclusionsImpl tests;
    @NotNull
    private final KoverSourcesExclusionsImpl sources;
    @NotNull
    private final KoverInstrumentationExclusionsImpl instrumentation;

    @Override
    public boolean getDisabledForProject() {
        return this.disabledForProject;
    }

    @Override
    public void setDisabledForProject(boolean bl) {
        this.disabledForProject = bl;
    }

    @Nullable
    public final CoverageToolVariant getToolVariant$kover_gradle_plugin() {
        return this.toolVariant;
    }

    public final void setToolVariant$kover_gradle_plugin(@Nullable CoverageToolVariant coverageToolVariant) {
        this.toolVariant = coverageToolVariant;
    }

    @Override
    public void useKoverTool() {
        this.toolVariant = KoverToolDefaultVariant.INSTANCE;
    }

    @Override
    public void useJacocoTool() {
        this.toolVariant = JacocoToolDefaultVariant.INSTANCE;
    }

    @Override
    public void useKoverTool(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        SemVer semVer = SemVer.Companion.ofThreePartOrNull("1.0.709");
        if (semVer == null) {
            throw (Throwable)((Object)new KoverCriticalException("Incorrect minimal version of kover tool '1.0.709'", null, 2, null));
        }
        SemVer minimal = semVer;
        SemVer semVer2 = SemVer.Companion.ofThreePartOrNull(version);
        if (semVer2 == null) {
            throw (Throwable)((Object)new KoverIllegalConfigException("Incorrect version of kover tool '1.0.709', expected version in format '1.2.3'"));
        }
        SemVer custom = semVer2;
        if (custom.compareTo(minimal) < 0) {
            throw (Throwable)((Object)new KoverIllegalConfigException("Specified kover tool version '" + version + "' lower then expected minimal '1.0.709'"));
        }
        this.toolVariant = new KoverToolVariant(version);
    }

    @Override
    public void useJacocoTool(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.toolVariant = new JacocoToolVariant(version);
    }

    @Override
    public void excludeTests(@NotNull Action<KoverTestsExclusions> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        ActionExtensionsKt.invoke(config, (Object)this.tests);
    }

    @Override
    public void excludeSources(@NotNull Action<KoverSourcesExclusions> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        ActionExtensionsKt.invoke(config, (Object)this.sources);
    }

    @Override
    public void excludeInstrumentation(@NotNull Action<KoverInstrumentationExclusions> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        ActionExtensionsKt.invoke(config, (Object)this.instrumentation);
    }

    @NotNull
    public final KoverTestsExclusionsImpl getTests$kover_gradle_plugin() {
        return this.tests;
    }

    @NotNull
    public final KoverSourcesExclusionsImpl getSources$kover_gradle_plugin() {
        return this.sources;
    }

    @NotNull
    public final KoverInstrumentationExclusionsImpl getInstrumentation$kover_gradle_plugin() {
        return this.instrumentation;
    }

    @Inject
    public KoverProjectExtensionImpl(@NotNull ObjectFactory objects) {
        ObjectFactory $this$newInstance$iv;
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        ObjectFactory objectFactory = objects;
        Object[] parameters$iv = new Object[]{};
        boolean $i$f$newInstance = false;
        this.tests = (KoverTestsExclusionsImpl)$this$newInstance$iv.newInstance(KoverTestsExclusionsImpl.class, Arrays.copyOf(parameters$iv, parameters$iv.length));
        $this$newInstance$iv = objects;
        parameters$iv = new Object[]{};
        $i$f$newInstance = false;
        this.sources = (KoverSourcesExclusionsImpl)$this$newInstance$iv.newInstance(KoverSourcesExclusionsImpl.class, Arrays.copyOf(parameters$iv, parameters$iv.length));
        $this$newInstance$iv = objects;
        parameters$iv = new Object[]{};
        $i$f$newInstance = false;
        this.instrumentation = (KoverInstrumentationExclusionsImpl)$this$newInstance$iv.newInstance(KoverInstrumentationExclusionsImpl.class, Arrays.copyOf(parameters$iv, parameters$iv.length));
    }
}

