/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tools.jacoco;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.kover.gradle.plugin.commons.KoverCriticalException;
import kotlinx.kover.gradle.plugin.commons.ReportContext;
import kotlinx.kover.gradle.plugin.commons.ReportFilters;
import kotlinx.kover.gradle.plugin.commons.VerificationBound;
import kotlinx.kover.gradle.plugin.commons.VerificationRule;
import kotlinx.kover.gradle.plugin.dsl.AggregationType;
import kotlinx.kover.gradle.plugin.dsl.GroupingEntityType;
import kotlinx.kover.gradle.plugin.dsl.MetricType;
import kotlinx.kover.gradle.plugin.tools.BoundViolations;
import kotlinx.kover.gradle.plugin.tools.RuleViolations;
import kotlinx.kover.gradle.plugin.tools.jacoco.JacocoAntKt;
import kotlinx.kover.gradle.plugin.tools.jacoco.VerificationKt;
import kotlinx.kover.gradle.plugin.tools.jacoco.VerificationKt$WhenMappings;
import kotlinx.kover.gradle.plugin.util.UtilKt;
import org.gradle.internal.reflect.JavaMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\f\u001a\u00020\r*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u001a(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u0018H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"errorMessageRegex", "Lkotlin/text/Regex;", "asAggType", "Lkotlinx/kover/gradle/plugin/dsl/AggregationType;", "", "line", "asEntityType", "Lkotlinx/kover/gradle/plugin/dsl/GroupingEntityType;", "asIsMax", "", "asMetricType", "Lkotlinx/kover/gradle/plugin/dsl/MetricType;", "asValue", "Ljava/math/BigDecimal;", "aggregationType", "jacocoVerify", "", "Lkotlinx/kover/gradle/plugin/tools/RuleViolations;", "Lkotlinx/kover/gradle/plugin/commons/ReportContext;", "rules", "Lkotlinx/kover/gradle/plugin/commons/VerificationRule;", "filters", "Lkotlinx/kover/gradle/plugin/commons/ReportFilters;", "violations", "Lgroovy/lang/GroovyObject;", "kover-gradle-plugin"})
public final class VerificationKt {
    private static final Regex errorMessageRegex;

    @NotNull
    public static final List<RuleViolations> jacocoVerify(@NotNull ReportContext $this$jacocoVerify, @NotNull List<? extends VerificationRule> rules, @NotNull ReportFilters filters) {
        Intrinsics.checkNotNullParameter((Object)$this$jacocoVerify, (String)"$this$jacocoVerify");
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        JacocoAntKt.callAntReport($this$jacocoVerify, filters, $this$jacocoVerify.getProjectPath(), (Function1<? super GroovyObject, Unit>)((Function1)new Function1<GroovyObject, Unit>(rules){
            final /* synthetic */ List $rules;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull GroovyObject $this$callAntReport) {
                void name$iv;
                void $this$invokeWithBody$iv;
                Intrinsics.checkNotNullParameter((Object)$this$callAntReport, (String)"$receiver");
                GroovyObject groovyObject = $this$callAntReport;
                String string = "check";
                Map args$iv = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"failonviolation", (Object)"false"), TuplesKt.to((Object)"violationsproperty", (Object)"jacocoErrors")});
                boolean $i$f$invokeWithBody = false;
                $this$invokeWithBody$iv.invokeMethod((String)name$iv, (Object)CollectionsKt.listOf((Object[])new Object[]{args$iv, new Closure<Object>((GroovyObject)$this$invokeWithBody$iv, (Object)$this$invokeWithBody$iv, this){
                    final /* synthetic */ GroovyObject $this_invokeWithBody;
                    final /* synthetic */ jacocoVerify.1 this$0;
                    {
                        this.$this_invokeWithBody = $receiver;
                        this.this$0 = var3_3;
                        super($super_call_param$2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object doCall(@Nullable Object ignore) {
                        GroovyObject $this$invokeWithBody = this.$this_invokeWithBody;
                        boolean bl = false;
                        Iterable $this$forEach$iv = this.this$0.$rules;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            void name$iv;
                            void $this$invokeWithBody$iv;
                            String string;
                            VerificationRule it = (VerificationRule)element$iv;
                            boolean bl2 = false;
                            switch (VerificationKt$WhenMappings.$EnumSwitchMapping$0[it.getEntityType().ordinal()]) {
                                case 1: {
                                    string = "BUNDLE";
                                    break;
                                }
                                case 2: {
                                    string = "CLASS";
                                    break;
                                }
                                case 3: {
                                    string = "PACKAGE";
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            String entityType = string;
                            GroovyObject groovyObject = $this$invokeWithBody;
                            String string2 = "rule";
                            Map args$iv = MapsKt.mapOf((Pair)TuplesKt.to((Object)"element", (Object)entityType));
                            boolean $i$f$invokeWithBody = false;
                            $this$invokeWithBody$iv.invokeMethod((String)name$iv, (Object)CollectionsKt.listOf((Object[])new Object[]{args$iv, new Closure<Object>((GroovyObject)$this$invokeWithBody$iv, (Object)$this$invokeWithBody$iv, it){
                                final /* synthetic */ GroovyObject $this_invokeWithBody;
                                final /* synthetic */ VerificationRule $it$inlined;
                                {
                                    this.$this_invokeWithBody = $receiver;
                                    this.$it$inlined = verificationRule;
                                    super($super_call_param$2);
                                }

                                @Nullable
                                public final Object doCall(@Nullable Object ignore) {
                                    GroovyObject $this$invokeWithBody = this.$this_invokeWithBody;
                                    boolean bl = false;
                                    Iterable $this$forEach$iv = this.$it$inlined.getBounds$kover_gradle_plugin();
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        String string;
                                        VerificationBound b = (VerificationBound)element$iv;
                                        boolean bl2 = false;
                                        Map limitArgs = new LinkedHashMap<K, V>();
                                        switch (VerificationKt$WhenMappings.$EnumSwitchMapping$1[b.getMetric().ordinal()]) {
                                            case 1: {
                                                string = "LINE";
                                                break;
                                            }
                                            case 2: {
                                                string = "INSTRUCTION";
                                                break;
                                            }
                                            case 3: {
                                                string = "BRANCH";
                                                break;
                                            }
                                            default: {
                                                throw new NoWhenBranchMatchedException();
                                            }
                                        }
                                        limitArgs.put("counter", string);
                                        BigDecimal min = b.getMinValue();
                                        BigDecimal max = b.getMaxValue();
                                        switch (VerificationKt$WhenMappings.$EnumSwitchMapping$2[b.getAggregation().ordinal()]) {
                                            case 1: {
                                                limitArgs.put("value", "COVEREDCOUNT");
                                                break;
                                            }
                                            case 2: {
                                                limitArgs.put("value", "MISSEDCOUNT");
                                                break;
                                            }
                                            case 3: {
                                                limitArgs.put("value", "COVEREDRATIO");
                                                BigDecimal bigDecimal = min;
                                                min = bigDecimal != null ? bigDecimal.divide(UtilKt.getONE_HUNDRED()) : null;
                                                BigDecimal bigDecimal2 = max;
                                                max = bigDecimal2 != null ? bigDecimal2.divide(UtilKt.getONE_HUNDRED()) : null;
                                                break;
                                            }
                                            case 4: {
                                                limitArgs.put("value", "MISSEDRATIO");
                                                BigDecimal bigDecimal = min;
                                                min = bigDecimal != null ? bigDecimal.divide(UtilKt.getONE_HUNDRED()) : null;
                                                BigDecimal bigDecimal3 = max;
                                                BigDecimal bigDecimal4 = max = bigDecimal3 != null ? bigDecimal3.divide(UtilKt.getONE_HUNDRED()) : null;
                                            }
                                        }
                                        if (min != null) {
                                            String string2 = min.toPlainString();
                                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"min.toPlainString()");
                                            limitArgs.put("minimum", string2);
                                        }
                                        if (max != null) {
                                            String string3 = max.toPlainString();
                                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"max.toPlainString()");
                                            limitArgs.put("maximum", string3);
                                        }
                                        $this$invokeWithBody.invokeMethod("limit", (Object)limitArgs);
                                    }
                                    return null;
                                }
                            }}));
                        }
                        return null;
                    }
                }}));
            }
            {
                this.$rules = list;
                super(1);
            }
        }));
        return VerificationKt.violations((GroovyObject)$this$jacocoVerify.getServices().getAntBuilder());
    }

    /*
     * WARNING - void declaration
     */
    private static final List<RuleViolations> violations(GroovyObject $this$violations) {
        void $this$mapTo$iv$iv;
        Object project = $this$violations.getProperty("project");
        Object object = JavaMethod.of((Object)project, Hashtable.class, (String)"getProperties", (Class[])new Class[0]).invoke(project, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"JavaMethod.of(\n        p\u2026roject, *arrayOfNulls(0))");
        Hashtable properties = (Hashtable)object;
        Map map2 = properties;
        String string = "jacocoErrors";
        String string2 = (String)map2.get(string);
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String allErrorsString = string2;
        Iterable $this$map$iv = CollectionsKt.sorted((Iterable)StringsKt.lines((CharSequence)allErrorsString));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MatchResult match;
            void it;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (Regex.find$default((Regex)errorMessageRegex, (CharSequence)((CharSequence)it), (int)0, (int)2, null) == null) {
                throw (Throwable)((Object)new KoverCriticalException("Can't parse JaCoCo verification error string:\n" + (String)it, null, 2, null));
            }
            GroupingEntityType entityType = VerificationKt.asEntityType((String)match.getGroupValues().get(1), (String)it);
            String entityName = (String)match.getGroupValues().get(2);
            MetricType metric = VerificationKt.asMetricType((String)match.getGroupValues().get(3), (String)it);
            AggregationType agg = VerificationKt.asAggType((String)match.getGroupValues().get(4), (String)it);
            BigDecimal value = VerificationKt.asValue((String)match.getGroupValues().get(5), (String)it, agg);
            boolean isMax = VerificationKt.asIsMax((String)match.getGroupValues().get(6), (String)it);
            BigDecimal expected = VerificationKt.asValue((String)match.getGroupValues().get(7), (String)it, agg);
            RuleViolations ruleViolations = new RuleViolations(entityType, CollectionsKt.listOf((Object)new BoundViolations(isMax, expected, value, metric, agg, entityName)), null, 4, null);
            collection.add(ruleViolations);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private static final GroupingEntityType asEntityType(String $this$asEntityType, String line) {
        GroupingEntityType groupingEntityType;
        switch ($this$asEntityType) {
            case "bundle": {
                groupingEntityType = GroupingEntityType.APPLICATION;
                break;
            }
            case "class": {
                groupingEntityType = GroupingEntityType.CLASS;
                break;
            }
            case "package": {
                groupingEntityType = GroupingEntityType.PACKAGE;
                break;
            }
            default: {
                throw (Throwable)((Object)new KoverCriticalException("Unknown JaCoCo entity type '" + $this$asEntityType + "' in verification error:\n" + line, null, 2, null));
            }
        }
        return groupingEntityType;
    }

    private static final MetricType asMetricType(String $this$asMetricType, String line) {
        MetricType metricType;
        switch ($this$asMetricType) {
            case "lines": {
                metricType = MetricType.LINE;
                break;
            }
            case "instructions": {
                metricType = MetricType.INSTRUCTION;
                break;
            }
            case "branches": {
                metricType = MetricType.BRANCH;
                break;
            }
            default: {
                throw (Throwable)((Object)new KoverCriticalException("Unknown JaCoCo metric type '" + $this$asMetricType + "' in verification error:\n" + line, null, 2, null));
            }
        }
        return metricType;
    }

    private static final AggregationType asAggType(String $this$asAggType, String line) {
        AggregationType aggregationType;
        switch ($this$asAggType) {
            case "covered ratio": {
                aggregationType = AggregationType.COVERED_PERCENTAGE;
                break;
            }
            case "missed ratio": {
                aggregationType = AggregationType.MISSED_PERCENTAGE;
                break;
            }
            case "covered count": {
                aggregationType = AggregationType.COVERED_COUNT;
                break;
            }
            case "missed count": {
                aggregationType = AggregationType.MISSED_COUNT;
                break;
            }
            default: {
                throw (Throwable)((Object)new KoverCriticalException("Unknown JaCoCo aggregation type '" + $this$asAggType + "' in verification error:\n" + line, null, 2, null));
            }
        }
        return aggregationType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean asIsMax(String $this$asIsMax, String line) {
        String string = $this$asIsMax;
        switch (string.hashCode()) {
            case 844740128: {
                if (!string.equals("maximum")) throw (Throwable)((Object)new KoverCriticalException("Unknown JaCoCo direction '" + $this$asIsMax + "' in verification error:\n" + line, null, 2, null));
                return true;
            }
            case 1064538126: {
                if (!string.equals("minimum")) throw (Throwable)((Object)new KoverCriticalException("Unknown JaCoCo direction '" + $this$asIsMax + "' in verification error:\n" + line, null, 2, null));
                return false;
            }
        }
        throw (Throwable)((Object)new KoverCriticalException("Unknown JaCoCo direction '" + $this$asIsMax + "' in verification error:\n" + line, null, 2, null));
    }

    private static final BigDecimal asValue(String $this$asValue, String line, AggregationType aggregationType) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = StringsKt.toBigDecimalOrNull((String)$this$asValue);
        if (bigDecimal2 == null) {
            throw (Throwable)((Object)new KoverCriticalException("Illegal JaCoCo metric value '" + $this$asValue + "' in verification error:\n" + line, null, 2, null));
        }
        BigDecimal value = bigDecimal2;
        if (aggregationType.isPercentage()) {
            BigDecimal bigDecimal3 = value;
            BigDecimal bigDecimal4 = UtilKt.getONE_HUNDRED();
            BigDecimal bigDecimal5 = bigDecimal3.multiply(bigDecimal4);
            bigDecimal = bigDecimal5;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"this.multiply(other)");
        } else {
            bigDecimal = value;
        }
        return bigDecimal;
    }

    static {
        String string = "Rule violated for (\\w+) (.+): (\\w+) (.+) is ([\\d\\.]+), but expected (\\w+) is ([\\d\\.]+)";
        errorMessageRegex = new Regex(string);
    }
}

