/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.util.json;

import java.io.Closeable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\t\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H$J\b\u0010\u0005\u001a\u00020\u0006H$J\b\u0010\u0007\u001a\u00020\bH$J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u000b\u001a\u00020\fH$J\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n\u0018\u00010\u0012J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0006H\u0002J\b\u0010\u0016\u001a\u00020\u0006H\u0002J\b\u0010\u0017\u001a\u00020\u0006H\u0002J\b\u0010\u0018\u001a\u00020\u0006H\u0002J\b\u0010\u0019\u001a\u00020\u0006H\u0002J\b\u0010\u001a\u001a\u00020\u0006H\u0002J\b\u0010\u001b\u001a\u00020\u0006H\u0002\u00a8\u0006\u001c"}, d2={"Lkotlinx/kover/gradle/plugin/util/json/JsonReader;", "Ljava/io/Closeable;", "()V", "char", "", "eof", "", "next", "", "nextValue", "", "pos", "", "readArray", "", "readNumber", "Ljava/math/BigDecimal;", "readObject", "", "", "readStringLiteral", "skipArrayClose", "skipArrayOpen", "skipComma", "skipObjectClose", "skipObjectOpen", "skipSpaces", "skipValueDelimiter", "kover-gradle-plugin"})
public abstract class JsonReader
implements Closeable {
    @Nullable
    public final Map<String, Object> readObject() {
        this.skipSpaces();
        if (!this.skipObjectOpen()) {
            return null;
        }
        boolean isFirst = true;
        Map result = new LinkedHashMap();
        while (!this.skipObjectClose()) {
            Object fieldValue;
            String fieldName;
            if (this.eof()) {
                throw (Throwable)new Exception("Unexpected end of file: object is not closed");
            }
            if (!isFirst && !this.skipComma()) {
                throw (Throwable)new Exception("Expected comma between object fields at pos " + this.pos());
            }
            isFirst = false;
            if (this.readStringLiteral() == null) {
                throw (Throwable)new Exception("Can't read name of field at pos " + this.pos());
            }
            if (!this.skipValueDelimiter()) {
                throw (Throwable)new Exception("Expected ':' or '=' char between field name and value inside the object at pos " + this.pos());
            }
            if (this.nextValue() == null) {
                throw (Throwable)new Exception("Can't read value of the field at pos " + this.pos());
            }
            result.put(fieldName, fieldValue);
        }
        return result;
    }

    @Nullable
    public final List<Object> readArray() {
        this.skipSpaces();
        if (!this.skipArrayOpen()) {
            return null;
        }
        List result = new ArrayList();
        boolean isFirst = true;
        while (!this.skipArrayClose()) {
            Object object;
            if (this.eof()) {
                throw (Throwable)new Exception("Unexpected end of file: array is not closed");
            }
            if (!isFirst && !this.skipComma()) {
                throw (Throwable)new Exception("Expected comma between array values at pos " + this.pos());
            }
            isFirst = false;
            Collection collection = result;
            if (this.nextValue() == null) {
                throw (Throwable)new Exception("Can't read value of in the array at pos " + this.pos());
            }
            collection.add(object);
        }
        return result;
    }

    private final Object nextValue() {
        String string = this.readStringLiteral();
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            return it;
        }
        Map<String, Object> map2 = this.readObject();
        if (map2 != null) {
            Map<String, Object> map3;
            Map<String, Object> it = map3 = map2;
            boolean bl = false;
            return it;
        }
        List<Object> list = this.readArray();
        if (list != null) {
            List<Object> list2;
            List<Object> it = list2 = list;
            boolean bl = false;
            return it;
        }
        BigDecimal bigDecimal = this.readNumber();
        if (bigDecimal != null) {
            BigDecimal bigDecimal2;
            BigDecimal it = bigDecimal2 = bigDecimal;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private final String readStringLiteral() {
        this.skipSpaces();
        if (this.char() != '\"') {
            return null;
        }
        char[] buffer = new char[16];
        int size = 0;
        this.next();
        while (this.char() != '\"') {
            if (size == buffer.length) {
                char[] cArray = buffer;
                int n = size * 2;
                Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(cArray, n), (String)"copyOf(this, newSize)");
            }
            buffer[size++] = this.char();
            this.next();
            if (!this.eof()) continue;
            throw (Throwable)new Exception("Unexpected end of file: string literal is not terminated");
        }
        this.next();
        return StringsKt.concatToString((char[])buffer, (int)0, (int)size);
    }

    private final BigDecimal readNumber() {
        char c;
        this.skipSpaces();
        char c2 = this.char();
        if (!Character.isDigit(c2) && this.char() != '-') {
            return null;
        }
        boolean hasDot = false;
        char[] buffer = new char[8];
        int size = 0;
        buffer[size++] = this.char();
        this.next();
        while (!this.eof() && !CharsKt.isWhitespace((char)(c = this.char())) && c != ',' && c != '}' && c != ']') {
            char c3;
            if (size == buffer.length) {
                char[] cArray = buffer;
                int n = size * 2;
                Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(cArray, n), (String)"copyOf(this, newSize)");
            }
            if (Character.isDigit(c3 = c)) {
                buffer[size++] = c;
                this.next();
                continue;
            }
            if (c == '.') {
                if (hasDot) {
                    throw (Throwable)new Exception("");
                }
                buffer[size++] = c;
                this.next();
                hasDot = true;
                continue;
            }
            throw (Throwable)new Exception("");
        }
        String string = StringsKt.concatToString((char[])buffer, (int)0, (int)size);
        return new BigDecimal(string);
    }

    private final boolean skipComma() {
        boolean bl;
        this.skipSpaces();
        switch (this.char()) {
            case ',': {
                this.next();
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean skipValueDelimiter() {
        boolean bl;
        this.skipSpaces();
        switch (this.char()) {
            case ':': {
                this.next();
                bl = true;
                break;
            }
            case '=': {
                this.next();
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean skipArrayOpen() {
        this.skipSpaces();
        if (this.char() == '[') {
            this.next();
            return true;
        }
        return false;
    }

    private final boolean skipArrayClose() {
        this.skipSpaces();
        if (this.char() == ']') {
            this.next();
            return true;
        }
        return false;
    }

    private final boolean skipObjectOpen() {
        this.skipSpaces();
        if (this.char() == '{') {
            this.next();
            return true;
        }
        return false;
    }

    private final boolean skipObjectClose() {
        this.skipSpaces();
        if (this.char() == '}') {
            this.next();
            return true;
        }
        return false;
    }

    private final boolean skipSpaces() {
        boolean hasSpaces = false;
        while (!this.eof() && CharsKt.isWhitespace((char)this.char())) {
            this.next();
            hasSpaces = true;
        }
        return hasSpaces;
    }

    protected abstract int pos();

    protected abstract boolean eof();

    protected abstract void next();

    protected abstract char char();
}

