/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.commons;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.commons.CoverageToolVendor;
import kotlinx.kover.gradle.plugin.commons.NamingKt;
import kotlinx.kover.gradle.plugin.tools.CoverageToolVariant;
import org.gradle.configurationcache.extensions.CharSequenceExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\b\u0010\r\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"separator", "", "agentFilePath", "", "toolVariant", "Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "artifactFilePath", "variant", "htmlReportPath", "rawReportPath", "taskName", "toolVendor", "Lkotlinx/kover/gradle/plugin/commons/CoverageToolVendor;", "rawReportsRootPath", "verificationErrorsPath", "xmlReportPath", "kover-gradle-plugin"})
public final class PathsKt {
    private static final char separator = File.separatorChar;

    @NotNull
    public static final String agentFilePath(@NotNull CoverageToolVariant toolVariant) {
        Intrinsics.checkNotNullParameter((Object)toolVariant, (String)"toolVariant");
        return toolVariant.getVendor() == CoverageToolVendor.KOVER ? "kover" + separator + "intellij-coverage-agent-" + toolVariant.getVersion() + ".jar" : "kover" + separator + "jacoco-coverage-agent-" + toolVariant.getVersion() + ".jar";
    }

    @NotNull
    public static final String rawReportsRootPath() {
        return "kover" + separator + "raw-reports";
    }

    @NotNull
    public static final String rawReportPath(@NotNull String taskName, @NotNull CoverageToolVendor toolVendor) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)((Object)toolVendor), (String)"toolVendor");
        return PathsKt.rawReportsRootPath() + separator + NamingKt.rawReportName(taskName, toolVendor);
    }

    @NotNull
    public static final String htmlReportPath(@NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return "reports" + separator + "kover" + separator + "html" + CharSequenceExtensionsKt.capitalized((CharSequence)variant);
    }

    @NotNull
    public static final String xmlReportPath(@NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return "reports" + separator + "kover" + separator + "report" + CharSequenceExtensionsKt.capitalized((CharSequence)variant) + ".xml";
    }

    @NotNull
    public static final String verificationErrorsPath(@NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return "reports" + separator + "kover" + separator + "verify" + CharSequenceExtensionsKt.capitalized((CharSequence)variant) + ".err";
    }

    @NotNull
    public static final String artifactFilePath(@NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return Intrinsics.areEqual((Object)variant, (Object)"") ? "kover" + separator + "default.artifact" : "kover" + separator + variant + ".artifact";
    }
}

