/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.locators;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.commons.AndroidCompilationKit;
import kotlinx.kover.gradle.plugin.commons.AppliedKotlinPlugin;
import kotlinx.kover.gradle.plugin.commons.KotlinPluginType;
import kotlinx.kover.gradle.plugin.commons.KoverCriticalException;
import kotlinx.kover.gradle.plugin.commons.ProjectCompilation;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverProjectExtensionImpl;
import kotlinx.kover.gradle.plugin.locators.AndroidKt;
import kotlinx.kover.gradle.plugin.locators.CompilationKitLocator;
import kotlinx.kover.gradle.plugin.util.DynamicBean;
import kotlinx.kover.gradle.plugin.util.DynamicBeanKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lkotlinx/kover/gradle/plugin/locators/KotlinAndroidLocator;", "Lkotlinx/kover/gradle/plugin/locators/CompilationKitLocator;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "locate", "Lkotlinx/kover/gradle/plugin/commons/ProjectCompilation;", "koverExtension", "Lkotlinx/kover/gradle/plugin/dsl/internal/KoverProjectExtensionImpl;", "Companion", "kover-gradle-plugin"})
public final class KotlinAndroidLocator
implements CompilationKitLocator {
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ProjectCompilation locate(@NotNull KoverProjectExtensionImpl koverExtension) {
        Intrinsics.checkNotNullParameter((Object)koverExtension, (String)"koverExtension");
        Object object = this.project.getExtensions().findByName("android");
        if (object == null || (object = DynamicBeanKt.bean(object)) == null) {
            throw (Throwable)((Object)new KoverCriticalException("Kover requires extension with name 'android' for project '" + this.project.getPath() + "' since it is recognized as Kotlin/Android project", null, 2, null));
        }
        Object androidExtension = object;
        Object object2 = this.project.getExtensions().findByName("kotlin");
        if (object2 == null || (object2 = DynamicBeanKt.bean(object2)) == null) {
            throw (Throwable)((Object)new KoverCriticalException("Kover requires extension with name 'kotlin' for project '" + this.project.getPath() + "' since it is recognized as Kotlin/Android project", null, 2, null));
        }
        Object kotlinExtension = object2;
        DynamicBean kotlinTarget = ((DynamicBean)kotlinExtension).get("target");
        List<AndroidCompilationKit> androidKits = AndroidKt.androidCompilationKits(this.project, (DynamicBean)androidExtension, koverExtension, kotlinTarget);
        return new ProjectCompilation(new AppliedKotlinPlugin(KotlinPluginType.ANDROID), null, androidKits, 2, null);
    }

    public KotlinAndroidLocator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lkotlinx/kover/gradle/plugin/locators/KotlinAndroidLocator$Companion;", "", "()V", "isApplied", "", "project", "Lorg/gradle/api/Project;", "kover-gradle-plugin"})
    public static final class Companion {
        public final boolean isApplied(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return project.getPlugins().hasPlugin("kotlin-android");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

