/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tasks;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.commons.ReportFilters;
import kotlinx.kover.gradle.plugin.tasks.AbstractKoverReportTask;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\u0006\u0010\u0012\u001a\u00020\u0013R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00020\u000b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0014"}, d2={"Lkotlinx/kover/gradle/plugin/tasks/KoverHtmlTask;", "Lkotlinx/kover/gradle/plugin/tasks/AbstractKoverReportTask;", "tool", "Lkotlinx/kover/gradle/plugin/tools/CoverageTool;", "(Lkotlinx/kover/gradle/plugin/tools/CoverageTool;)V", "charset", "Lorg/gradle/api/provider/Property;", "", "getCharset", "()Lorg/gradle/api/provider/Property;", "reportDir", "Lorg/gradle/api/file/DirectoryProperty;", "getReportDir", "()Lorg/gradle/api/file/DirectoryProperty;", "title", "getTitle", "generate", "", "printPath", "", "kover-gradle-plugin"})
public class KoverHtmlTask
extends AbstractKoverReportTask {
    @NotNull
    private final DirectoryProperty reportDir;
    @NotNull
    private final Property<String> title;
    @NotNull
    private final Property<String> charset;

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getReportDir() {
        return this.reportDir;
    }

    @Input
    @NotNull
    public final Property<String> getTitle() {
        return this.title;
    }

    @Input
    @Optional
    @NotNull
    public final Property<String> getCharset() {
        return this.charset;
    }

    @TaskAction
    public final void generate() {
        Object object = this.reportDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reportDir.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"reportDir.get().asFile");
        File htmlDir = file;
        htmlDir.mkdirs();
        CoverageTool coverageTool = this.getTool();
        Object object2 = this.title.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"title.get()");
        String string = (String)object2;
        String string2 = (String)this.charset.getOrNull();
        Object object3 = this.getFilters().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"filters.get()");
        coverageTool.htmlReport(htmlDir, string, string2, (ReportFilters)object3, this.context());
    }

    public final boolean printPath() {
        Logger logger = this.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("Kover: HTML report for '").append(this.getProjectPath()).append("' file://");
        Object object = this.reportDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reportDir.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"reportDir.get().asFile");
        logger.lifecycle(stringBuilder.append(file.getCanonicalPath()).append("/index.html").toString());
        return true;
    }

    @Inject
    public KoverHtmlTask(@NotNull CoverageTool tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        super(tool);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        DirectoryProperty directoryProperty = project.getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.objects.directoryProperty()");
        this.reportDir = directoryProperty;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        ObjectFactory objectFactory = project2.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.title = property;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        ObjectFactory objectFactory2 = project3.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory2, (String)"project.objects");
        $this$property$iv = objectFactory2;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        this.charset = property2;
    }
}

