/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.commons.KoverVerificationException;
import kotlinx.kover.gradle.plugin.commons.ReportFilters;
import kotlinx.kover.gradle.plugin.commons.VerificationRule;
import kotlinx.kover.gradle.plugin.tasks.AbstractKoverReportTask;
import kotlinx.kover.gradle.plugin.tasks.KoverVerifyTask$WhenMappings;
import kotlinx.kover.gradle.plugin.tools.BoundViolations;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import kotlinx.kover.gradle.plugin.tools.RuleViolations;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0011\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\u0014\u0010\u0015\u001a\u00020\u000f*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0002R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lkotlinx/kover/gradle/plugin/tasks/KoverVerifyTask;", "Lkotlinx/kover/gradle/plugin/tasks/AbstractKoverReportTask;", "tool", "Lkotlinx/kover/gradle/plugin/tools/CoverageTool;", "(Lkotlinx/kover/gradle/plugin/tools/CoverageTool;)V", "resultFile", "Lorg/gradle/api/file/RegularFileProperty;", "getResultFile", "()Lorg/gradle/api/file/RegularFileProperty;", "rules", "Lorg/gradle/api/provider/ListProperty;", "Lkotlinx/kover/gradle/plugin/commons/VerificationRule;", "getRules", "()Lorg/gradle/api/provider/ListProperty;", "generateErrorMessage", "", "violations", "", "Lkotlinx/kover/gradle/plugin/tools/RuleViolations;", "verify", "", "format", "Lkotlinx/kover/gradle/plugin/tools/BoundViolations;", "rule", "kover-gradle-plugin"})
public class KoverVerifyTask
extends AbstractKoverReportTask {
    @NotNull
    private final ListProperty<VerificationRule> rules;
    @NotNull
    private final RegularFileProperty resultFile;

    @Nested
    @NotNull
    public final ListProperty<VerificationRule> getRules() {
        return this.rules;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getResultFile() {
        return this.resultFile;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void verify() {
        void $this$filterTo$iv$iv;
        Object object = this.rules.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rules.get()");
        Iterable $this$filter$iv = (Iterable)object;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VerificationRule it = (VerificationRule)element$iv$iv;
            boolean bl = false;
            if (!it.isEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enabledRules = (List)destination$iv$iv;
        CoverageTool coverageTool = this.getTool();
        Object object2 = this.getFilters().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"filters.get()");
        List<RuleViolations> violations = coverageTool.verify(enabledRules, (ReportFilters)object2, this.context());
        Collection $i$f$filter22 = violations;
        if (!$i$f$filter22.isEmpty()) {
            String message = this.generateErrorMessage(violations);
            Object object3 = this.resultFile.get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"resultFile.get()");
            File file = ((RegularFile)object3).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resultFile.get().asFile");
            FilesKt.writeText$default((File)file, (String)message, null, (int)2, null);
            throw (Throwable)((Object)new KoverVerificationException(message));
        }
    }

    private final String generateErrorMessage(List<RuleViolations> violations) {
        StringBuilder messageBuilder = new StringBuilder();
        Iterable $this$forEach$iv = violations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            StringBuilder stringBuilder;
            String namedRule;
            RuleViolations rule = (RuleViolations)element$iv;
            boolean bl = false;
            String string2 = namedRule = rule.getName() != null ? "Rule '" + rule.getName() + '\'' : "Rule";
            if (rule.getBounds().size() == 1) {
                stringBuilder = messageBuilder;
                string = namedRule + " violated: " + this.format(rule.getBounds().get(0), rule);
                StringBuilder stringBuilder2 = stringBuilder.append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                continue;
            }
            stringBuilder = messageBuilder;
            string = namedRule + " violated:";
            StringBuilder stringBuilder3 = stringBuilder.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            Iterable $this$forEach$iv2 = rule.getBounds();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BoundViolations bound = (BoundViolations)element$iv2;
                boolean bl2 = false;
                messageBuilder.append("  ");
                StringBuilder stringBuilder4 = messageBuilder;
                String string3 = this.format(bound, rule);
                StringBuilder stringBuilder5 = stringBuilder4.append(string3);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            }
        }
        String string = messageBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"messageBuilder.toString()");
        return string;
    }

    private final String format(BoundViolations $this$format, RuleViolations rule) {
        String string;
        String string2;
        String string3;
        String directionText = $this$format.isMax() ? "maximum" : "minimum";
        switch (KoverVerifyTask$WhenMappings.$EnumSwitchMapping$0[$this$format.getMetric().ordinal()]) {
            case 1: {
                string3 = "lines";
                break;
            }
            case 2: {
                string3 = "instructions";
                break;
            }
            case 3: {
                string3 = "branches";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String metricText = string3;
        switch (KoverVerifyTask$WhenMappings.$EnumSwitchMapping$1[$this$format.getAggregation().ordinal()]) {
            case 1: {
                string2 = "covered count";
                break;
            }
            case 2: {
                string2 = "missed count";
                break;
            }
            case 3: {
                string2 = "covered percentage";
                break;
            }
            case 4: {
                string2 = "missed percentage";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String valueTypeText = string2;
        switch (KoverVerifyTask$WhenMappings.$EnumSwitchMapping$2[rule.getEntityType().ordinal()]) {
            case 1: {
                string = "";
                break;
            }
            case 2: {
                string = " for class '" + $this$format.getEntityName() + '\'';
                break;
            }
            case 3: {
                string = " for package '" + $this$format.getEntityName() + '\'';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String entityText = string;
        return metricText + ' ' + valueTypeText + entityText + " is " + $this$format.getActualValue() + ", but expected " + directionText + " is " + $this$format.getExpectedValue();
    }

    @Inject
    public KoverVerifyTask(@NotNull CoverageTool tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        super(tool);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        ObjectFactory $this$listProperty$iv = objectFactory;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(VerificationRule.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.rules = listProperty;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        RegularFileProperty regularFileProperty = project2.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"project.objects.fileProperty()");
        this.resultFile = regularFileProperty;
    }
}

