/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tasks;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.commons.ReportFilters;
import kotlinx.kover.gradle.plugin.tasks.AbstractKoverReportTask;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0007R\u0016\u0010\u0005\u001a\u00020\u00068AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lkotlinx/kover/gradle/plugin/tasks/KoverXmlTask;", "Lkotlinx/kover/gradle/plugin/tasks/AbstractKoverReportTask;", "tool", "Lkotlinx/kover/gradle/plugin/tools/CoverageTool;", "(Lkotlinx/kover/gradle/plugin/tools/CoverageTool;)V", "reportFile", "Lorg/gradle/api/file/RegularFileProperty;", "getReportFile$kover_gradle_plugin", "()Lorg/gradle/api/file/RegularFileProperty;", "generate", "", "kover-gradle-plugin"})
public class KoverXmlTask
extends AbstractKoverReportTask {
    @NotNull
    private final RegularFileProperty reportFile;

    @OutputFile
    @NotNull
    public final RegularFileProperty getReportFile$kover_gradle_plugin() {
        return this.reportFile;
    }

    @TaskAction
    public final void generate() {
        Object object = this.reportFile.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reportFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"reportFile.get().asFile");
        File xmlFile = file;
        xmlFile.getParentFile().mkdirs();
        CoverageTool coverageTool = this.getTool();
        Object object2 = this.getFilters().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"filters.get()");
        coverageTool.xmlReport(xmlFile, (ReportFilters)object2, this.context());
    }

    @Inject
    public KoverXmlTask(@NotNull CoverageTool tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        super(tool);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        RegularFileProperty regularFileProperty = project.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"project.objects.fileProperty()");
        this.reportFile = regularFileProperty;
    }
}

