/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tools.jacoco;

import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.commons.ReportContext;
import kotlinx.kover.gradle.plugin.commons.ReportFilters;
import kotlinx.kover.gradle.plugin.commons.VerificationRule;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import kotlinx.kover.gradle.plugin.tools.CoverageToolVariant;
import kotlinx.kover.gradle.plugin.tools.RuleViolations;
import kotlinx.kover.gradle.plugin.tools.jacoco.JacocoHtmlOrXmlReportKt;
import kotlinx.kover.gradle.plugin.tools.jacoco.JacocoOnlineInstrumentationKt;
import kotlinx.kover.gradle.plugin.tools.jacoco.JacocoTool;
import kotlinx.kover.gradle.plugin.tools.jacoco.VerificationKt;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J2\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J4\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060#H\u0016J,\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\n2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\n2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006+"}, d2={"Lkotlinx/kover/gradle/plugin/tools/jacoco/JacocoTool;", "Lkotlinx/kover/gradle/plugin/tools/CoverageTool;", "variant", "Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "(Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;)V", "jvmAgentDependency", "", "getJvmAgentDependency", "()Ljava/lang/String;", "jvmReporterDependencies", "", "getJvmReporterDependencies", "()Ljava/util/List;", "getVariant", "()Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "findJvmAgentJar", "Ljava/io/File;", "classpath", "Lorg/gradle/api/file/FileCollection;", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "htmlReport", "", "htmlDir", "title", "charset", "filters", "Lkotlinx/kover/gradle/plugin/commons/ReportFilters;", "context", "Lkotlinx/kover/gradle/plugin/commons/ReportContext;", "jvmAgentArgs", "jarFile", "tempDir", "rawReportFile", "excludedClasses", "", "verify", "Lkotlinx/kover/gradle/plugin/tools/RuleViolations;", "rules", "Lkotlinx/kover/gradle/plugin/commons/VerificationRule;", "commonFilters", "xmlReport", "xmlFile", "kover-gradle-plugin"})
public final class JacocoTool
implements CoverageTool {
    @NotNull
    private final String jvmAgentDependency;
    @NotNull
    private final List<String> jvmReporterDependencies;
    @NotNull
    private final CoverageToolVariant variant;

    @Override
    @NotNull
    public String getJvmAgentDependency() {
        return this.jvmAgentDependency;
    }

    @Override
    @NotNull
    public List<String> getJvmReporterDependencies() {
        return this.jvmReporterDependencies;
    }

    @Override
    @NotNull
    public File findJvmAgentJar(@NotNull FileCollection classpath, @NotNull ArchiveOperations archiveOperations) {
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)archiveOperations, (String)"archiveOperations");
        FileCollection fileCollection = classpath.filter((Spec)findJvmAgentJar.fatJar.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"classpath.filter { it.na\u2026ith(\"org.jacoco.agent\") }");
        File file = fileCollection.getSingleFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"classpath.filter { it.na\u2026coco.agent\") }.singleFile");
        File fatJar2 = file;
        FileCollection fileCollection2 = archiveOperations.zipTree((Object)fatJar2).filter((Spec)findJvmAgentJar.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"archiveOperations.zipTre\u2026me == \"jacocoagent.jar\" }");
        File file2 = fileCollection2.getSingleFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"archiveOperations.zipTre\u2026coagent.jar\" }.singleFile");
        return file2;
    }

    @Override
    @NotNull
    public List<String> jvmAgentArgs(@NotNull File jarFile, @NotNull File tempDir, @NotNull File rawReportFile, @NotNull Set<String> excludedClasses) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)rawReportFile, (String)"rawReportFile");
        Intrinsics.checkNotNullParameter(excludedClasses, (String)"excludedClasses");
        return JacocoOnlineInstrumentationKt.buildJvmAgentArgs(jarFile, rawReportFile, excludedClasses);
    }

    @Override
    public void xmlReport(@NotNull File xmlFile, @NotNull ReportFilters filters, @NotNull ReportContext context) {
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JacocoHtmlOrXmlReportKt.jacocoXmlReport(context, xmlFile, filters);
    }

    @Override
    public void htmlReport(@NotNull File htmlDir, @NotNull String title, @Nullable String charset, @NotNull ReportFilters filters, @NotNull ReportContext context) {
        Intrinsics.checkNotNullParameter((Object)htmlDir, (String)"htmlDir");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JacocoHtmlOrXmlReportKt.jacocoHtmlReport(context, htmlDir, title, charset, filters);
    }

    @Override
    @NotNull
    public List<RuleViolations> verify(@NotNull List<? extends VerificationRule> rules, @NotNull ReportFilters commonFilters, @NotNull ReportContext context) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Intrinsics.checkNotNullParameter((Object)commonFilters, (String)"commonFilters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return VerificationKt.jacocoVerify(context, rules, commonFilters);
    }

    @Override
    @NotNull
    public CoverageToolVariant getVariant() {
        return this.variant;
    }

    public JacocoTool(@NotNull CoverageToolVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.variant = variant;
        this.jvmAgentDependency = "org.jacoco:org.jacoco.agent:" + this.getVariant().getVersion();
        this.jvmReporterDependencies = CollectionsKt.listOf((Object[])new String[]{"org.jacoco:org.jacoco.agent:" + this.getVariant().getVersion(), "org.jacoco:org.jacoco.ant:" + this.getVariant().getVersion()});
    }
}

