/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.commons;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.commons.CoverageToolVendor;
import kotlinx.kover.gradle.plugin.commons.NamingKt;
import kotlinx.kover.gradle.plugin.tools.CoverageToolVariant;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\b\u0010\f\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"separator", "", "agentFilePath", "", "toolVariant", "Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "artifactFilePath", "variant", "binReportPath", "taskName", "toolVendor", "Lkotlinx/kover/gradle/plugin/commons/CoverageToolVendor;", "binReportsRootPath", "binaryReportPath", "coverageLogPath", "htmlReportPath", "verificationErrorsPath", "xmlReportPath", "kover-gradle-plugin"})
public final class PathsKt {
    private static final char separator = File.separatorChar;

    @NotNull
    public static final String agentFilePath(@NotNull CoverageToolVariant toolVariant) {
        Intrinsics.checkNotNullParameter((Object)toolVariant, (String)"toolVariant");
        return toolVariant.getVendor() == CoverageToolVendor.KOVER ? "kover" + separator + "intellij-coverage-agent-" + toolVariant.getVersion() + ".jar" : "kover" + separator + "jacoco-coverage-agent-" + toolVariant.getVersion() + ".jar";
    }

    @NotNull
    public static final String binReportsRootPath() {
        return "kover" + separator + "bin-reports";
    }

    @NotNull
    public static final String binReportPath(@NotNull String taskName, @NotNull CoverageToolVendor toolVendor) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)((Object)toolVendor), (String)"toolVendor");
        return PathsKt.binReportsRootPath() + separator + NamingKt.binReportName(taskName, toolVendor);
    }

    @NotNull
    public static final String htmlReportPath(@NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return "reports" + separator + "kover" + separator + "html" + NamingKt.capitalized(variant);
    }

    @NotNull
    public static final String xmlReportPath(@NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return "reports" + separator + "kover" + separator + "report" + NamingKt.capitalized(variant) + ".xml";
    }

    @NotNull
    public static final String binaryReportPath(@NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return "reports" + separator + "kover" + separator + "report" + NamingKt.capitalized(variant) + ".bin";
    }

    @NotNull
    public static final String verificationErrorsPath(@NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return "reports" + separator + "kover" + separator + "verify" + NamingKt.capitalized(variant) + ".err";
    }

    @NotNull
    public static final String coverageLogPath(@NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return "kover" + separator + "coverage" + NamingKt.capitalized(variant) + ".txt";
    }

    @NotNull
    public static final String artifactFilePath(@NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return Intrinsics.areEqual((Object)variant, (Object)"") ? "kover" + separator + "default.artifact" : "kover" + separator + variant + ".artifact";
    }
}

