/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tasks.reports;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.tasks.reports.AbstractKoverReportTask;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b!\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lkotlinx/kover/gradle/plugin/tasks/reports/KoverHtmlTask;", "Lkotlinx/kover/gradle/plugin/tasks/reports/AbstractKoverReportTask;", "()V", "charset", "Lorg/gradle/api/provider/Property;", "", "getCharset", "()Lorg/gradle/api/provider/Property;", "reportDir", "Lorg/gradle/api/file/DirectoryProperty;", "getReportDir", "()Lorg/gradle/api/file/DirectoryProperty;", "title", "getTitle", "generate", "", "printPath", "", "kover-gradle-plugin"})
public abstract class KoverHtmlTask
extends AbstractKoverReportTask {
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getReportDir();

    @Input
    @NotNull
    public abstract Property<String> getTitle();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getCharset();

    @TaskAction
    public final void generate() {
        File file = ((Directory)this.getReportDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"reportDir.get().asFile");
        File htmlDir = file;
        htmlDir.mkdirs();
        CoverageTool coverageTool = (CoverageTool)this.getTool().get();
        Object object = this.getTitle().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"title.get()");
        coverageTool.htmlReport(htmlDir, (String)object, (String)this.getCharset().getOrNull(), this.context());
    }

    public final boolean printPath() {
        this.getLogger().lifecycle("Kover: HTML report for '" + this.getProjectPath() + "' file://" + ((Directory)this.getReportDir().get()).getAsFile().getCanonicalPath() + "/index.html");
        return true;
    }
}

