/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tools;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.kover.gradle.plugin.dsl.AggregationType;
import kotlinx.kover.gradle.plugin.dsl.GroupingEntityType;
import kotlinx.kover.gradle.plugin.dsl.MetricType;
import kotlinx.kover.gradle.plugin.tools.BoundViolations;
import kotlinx.kover.gradle.plugin.tools.CoverageMeasures;
import kotlinx.kover.gradle.plugin.tools.CoverageValue;
import kotlinx.kover.gradle.plugin.tools.RuleViolations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\b\u001a\u00020\t*\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0000\u001a&\u0010\f\u001a\u00020\t*\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u00a8\u0006\u0010"}, d2={"generateErrorMessage", "", "violations", "", "Lkotlinx/kover/gradle/plugin/tools/RuleViolations;", "format", "Lkotlinx/kover/gradle/plugin/tools/BoundViolations;", "rule", "writeNoSources", "", "Ljava/io/File;", "header", "writeToFile", "Lkotlinx/kover/gradle/plugin/tools/CoverageMeasures;", "file", "lineFormat", "kover-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nVerification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Verification.kt\nkotlinx/kover/gradle/plugin/tools/VerificationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n1855#3,2:114\n1855#3:116\n1855#3,2:117\n1856#3:119\n*S KotlinDebug\n*F\n+ 1 Verification.kt\nkotlinx/kover/gradle/plugin/tools/VerificationKt\n*L\n17#1:114,2\n70#1:116\n78#1:117,2\n70#1:119\n*E\n"})
public final class VerificationKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeToFile(@NotNull CoverageMeasures $this$writeToFile, @NotNull File file, @Nullable String header, @NotNull String lineFormat) {
        Intrinsics.checkNotNullParameter((Object)$this$writeToFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)lineFormat, (String)"lineFormat");
        Object object = file;
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
        Object object2 = charset;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            Appendable appendable;
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl = false;
            String string = header;
            if (string != null) {
                String h = string;
                boolean bl2 = false;
                Appendable appendable2 = ((Appendable)writer).append(h);
                Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(value)");
                Appendable appendable3 = appendable2.append('\n');
                appendable = appendable3;
                Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append('\\n')");
            } else {
                appendable = null;
            }
            Iterable $this$forEach$iv = $this$writeToFile.getValues();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CoverageValue coverage = (CoverageValue)element$iv;
                boolean bl3 = false;
                String string2 = coverage.getEntityName();
                if (string2 == null) {
                    string2 = "application";
                }
                String entityName = string2;
                Appendable appendable4 = writer;
                String string3 = coverage.getValue().stripTrailingZeros().toPlainString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"coverage.value.stripTrai\u2026ngZeros().toPlainString()");
                CharSequence charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)lineFormat, (String)"<value>", (String)string3, (boolean)false, (int)4, null), (String)"<entity>", (String)entityName, (boolean)false, (int)4, null);
                Appendable appendable5 = appendable4.append(charSequence);
                Intrinsics.checkNotNullExpressionValue((Object)appendable5, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable5.append('\n'), (String)"append('\\n')");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeNoSources(@NotNull File $this$writeNoSources, @Nullable String header) {
        Intrinsics.checkNotNullParameter((Object)$this$writeNoSources, (String)"<this>");
        Object object = $this$writeNoSources;
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
        Object object2 = charset;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            Appendable appendable;
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl = false;
            String string = header;
            if (string != null) {
                String h = string;
                boolean bl2 = false;
                Appendable appendable2 = ((Appendable)writer).append(h);
                Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(value)");
                Appendable appendable3 = appendable2.append('\n');
                appendable = appendable3;
                Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append('\\n')");
            } else {
                appendable = null;
            }
            Appendable appendable4 = ((Appendable)writer).append("No sources");
            Intrinsics.checkNotNullExpressionValue((Object)appendable4, (String)"append(value)");
            Appendable appendable5 = appendable4.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)appendable5, (String)"append('\\n')");
            Appendable appendable6 = appendable5;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    @NotNull
    public static final String generateErrorMessage(@NotNull List<RuleViolations> violations) {
        Intrinsics.checkNotNullParameter(violations, (String)"violations");
        StringBuilder messageBuilder = new StringBuilder();
        Iterable $this$forEach$iv = violations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String namedRule;
            RuleViolations rule = (RuleViolations)element$iv;
            boolean bl = false;
            String string = namedRule = rule.getName() != null ? "Rule '" + rule.getName() + '\'' : "Rule";
            if (rule.getBounds().size() == 1) {
                StringBuilder stringBuilder = messageBuilder.append(namedRule + " violated: " + VerificationKt.format(rule.getBounds().get(0), rule));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                continue;
            }
            StringBuilder stringBuilder = messageBuilder.append(namedRule + " violated:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            Iterable $this$forEach$iv2 = rule.getBounds();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BoundViolations bound = (BoundViolations)element$iv2;
                boolean bl2 = false;
                messageBuilder.append("  ");
                StringBuilder stringBuilder2 = messageBuilder.append(VerificationKt.format(bound, rule));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            }
        }
        String string = messageBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"messageBuilder.toString()");
        return string;
    }

    private static final String format(BoundViolations $this$format, RuleViolations rule) {
        String string;
        String string2;
        String string3;
        String directionText = $this$format.isMax() ? "maximum" : "minimum";
        switch (WhenMappings.$EnumSwitchMapping$0[$this$format.getMetric().ordinal()]) {
            case 1: {
                string3 = "lines";
                break;
            }
            case 2: {
                string3 = "instructions";
                break;
            }
            case 3: {
                string3 = "branches";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String metricText = string3;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$format.getAggregation().ordinal()]) {
            case 1: {
                string2 = "covered count";
                break;
            }
            case 2: {
                string2 = "missed count";
                break;
            }
            case 3: {
                string2 = "covered percentage";
                break;
            }
            case 4: {
                string2 = "missed percentage";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String valueTypeText = string2;
        switch (WhenMappings.$EnumSwitchMapping$2[rule.getEntityType().ordinal()]) {
            case 1: {
                string = "";
                break;
            }
            case 2: {
                string = " for class '" + $this$format.getEntityName() + '\'';
                break;
            }
            case 3: {
                string = " for package '" + $this$format.getEntityName() + '\'';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String entityText = string;
        return metricText + ' ' + valueTypeText + entityText + " is " + $this$format.getActualValue() + ", but expected " + directionText + " is " + $this$format.getExpectedValue();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[MetricType.values().length];
            try {
                nArray[MetricType.LINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricType.INSTRUCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricType.BRANCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AggregationType.values().length];
            try {
                nArray[AggregationType.COVERED_COUNT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggregationType.MISSED_COUNT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggregationType.COVERED_PERCENTAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggregationType.MISSED_PERCENTAGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[GroupingEntityType.values().length];
            try {
                nArray[GroupingEntityType.APPLICATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GroupingEntityType.CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GroupingEntityType.PACKAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

