/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tools.jacoco;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.kover.gradle.plugin.commons.KoverCriticalException;
import kotlinx.kover.gradle.plugin.commons.KoverVerificationException;
import kotlinx.kover.gradle.plugin.commons.ReportContext;
import kotlinx.kover.gradle.plugin.commons.VerificationBound;
import kotlinx.kover.gradle.plugin.commons.VerificationRule;
import kotlinx.kover.gradle.plugin.dsl.AggregationType;
import kotlinx.kover.gradle.plugin.dsl.GroupingEntityType;
import kotlinx.kover.gradle.plugin.dsl.MetricType;
import kotlinx.kover.gradle.plugin.tools.BoundViolations;
import kotlinx.kover.gradle.plugin.tools.RuleViolations;
import kotlinx.kover.gradle.plugin.tools.jacoco.JacocoAntKt;
import kotlinx.kover.gradle.plugin.tools.jacoco.VerificationKt;
import kotlinx.kover.gradle.plugin.util.UtilKt;
import org.gradle.internal.reflect.JavaMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\f\u001a\u00020\r*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u001a \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010H\u0000\u001a\"\u0010\u0015\u001a\u00020\u0016*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\u0012\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"errorMessageRegex", "Lkotlin/text/Regex;", "asAggType", "Lkotlinx/kover/gradle/plugin/dsl/AggregationType;", "", "line", "asEntityType", "Lkotlinx/kover/gradle/plugin/dsl/GroupingEntityType;", "asIsMax", "", "asMetricType", "Lkotlinx/kover/gradle/plugin/dsl/MetricType;", "asValue", "Ljava/math/BigDecimal;", "aggregationType", "doJacocoVerify", "", "Lkotlinx/kover/gradle/plugin/tools/RuleViolations;", "Lkotlinx/kover/gradle/plugin/commons/ReportContext;", "rules", "Lkotlinx/kover/gradle/plugin/commons/VerificationRule;", "jacocoVerify", "", "outputFile", "Ljava/io/File;", "violations", "Lgroovy/lang/GroovyObject;", "kover-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nVerification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Verification.kt\nkotlinx/kover/gradle/plugin/tools/jacoco/VerificationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1549#2:168\n1620#2,2:169\n1622#2:172\n1#3:171\n*S KotlinDebug\n*F\n+ 1 Verification.kt\nkotlinx/kover/gradle/plugin/tools/jacoco/VerificationKt\n*L\n110#1:168\n110#1:169,2\n110#1:172\n*E\n"})
public final class VerificationKt {
    @NotNull
    private static final Regex errorMessageRegex = new Regex("Rule violated for (\\w+) (.+): (\\w+) (.+) is ([\\d\\.]+), but expected (\\w+) is ([\\d\\.]+)");

    public static final void jacocoVerify(@NotNull ReportContext $this$jacocoVerify, @NotNull List<? extends VerificationRule> rules, @NotNull File outputFile) {
        Intrinsics.checkNotNullParameter((Object)$this$jacocoVerify, (String)"<this>");
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        List<RuleViolations> violations = VerificationKt.doJacocoVerify($this$jacocoVerify, rules);
        String errorMessage = kotlinx.kover.gradle.plugin.tools.VerificationKt.generateErrorMessage(violations);
        FilesKt.writeText$default((File)outputFile, (String)errorMessage, null, (int)2, null);
        if (!((Collection)violations).isEmpty()) {
            throw new KoverVerificationException(errorMessage);
        }
    }

    @NotNull
    public static final List<RuleViolations> doJacocoVerify(@NotNull ReportContext $this$doJacocoVerify, @NotNull List<? extends VerificationRule> rules) {
        Intrinsics.checkNotNullParameter((Object)$this$doJacocoVerify, (String)"<this>");
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        JacocoAntKt.callAntReport($this$doJacocoVerify, $this$doJacocoVerify.getProjectPath(), (Function1<? super GroovyObject, Unit>)((Function1)new Function1<GroovyObject, Unit>(rules){
            final /* synthetic */ List<VerificationRule> $rules;
            {
                this.$rules = $rules;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull GroovyObject $this$callAntReport) {
                void name$iv;
                void $this$invokeWithBody$iv;
                void args$iv;
                Intrinsics.checkNotNullParameter((Object)$this$callAntReport, (String)"$this$callAntReport");
                GroovyObject groovyObject = $this$callAntReport;
                String string = "check";
                Object object = new Pair[]{TuplesKt.to((Object)"failonviolation", (Object)"false"), TuplesKt.to((Object)"violationsproperty", (Object)"jacocoErrors")};
                object = MapsKt.mapOf((Pair[])object);
                List<VerificationRule> list = this.$rules;
                boolean $i$f$invokeWithBody = false;
                Object[] objectArray = new Object[]{args$iv, new Closure<Object>((GroovyObject)$this$invokeWithBody$iv, list){
                    final /* synthetic */ GroovyObject $this_invokeWithBody;
                    final /* synthetic */ List $rules$inlined;
                    {
                        this.$this_invokeWithBody = $receiver;
                        this.$rules$inlined = list;
                        super((Object)$receiver);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object doCall(@Nullable Object ignore) {
                        GroovyObject $this$invoke_u24lambda_u243 = this.$this_invokeWithBody;
                        boolean bl = false;
                        Iterable $this$forEach$iv = this.$rules$inlined;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            void name$iv;
                            void $this$invokeWithBody$iv;
                            String string;
                            VerificationRule it = (VerificationRule)element$iv;
                            boolean bl2 = false;
                            switch (doJacocoVerify.WhenMappings.$EnumSwitchMapping$0[it.getEntityType().ordinal()]) {
                                case 1: {
                                    string = "BUNDLE";
                                    break;
                                }
                                case 2: {
                                    string = "CLASS";
                                    break;
                                }
                                case 3: {
                                    string = "PACKAGE";
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            String entityType = string;
                            GroovyObject groovyObject = $this$invoke_u24lambda_u243;
                            String string2 = "rule";
                            Map args$iv = MapsKt.mapOf((Pair)TuplesKt.to((Object)"element", (Object)entityType));
                            boolean $i$f$invokeWithBody = false;
                            Object[] objectArray = new Object[]{args$iv, new Closure<Object>((GroovyObject)$this$invokeWithBody$iv, it){
                                final /* synthetic */ GroovyObject $this_invokeWithBody;
                                final /* synthetic */ VerificationRule $it$inlined;
                                {
                                    this.$this_invokeWithBody = $receiver;
                                    this.$it$inlined = verificationRule;
                                    super((Object)$receiver);
                                }

                                @Nullable
                                public final Object doCall(@Nullable Object ignore) {
                                    GroovyObject $this$invoke_u24lambda_u243_u24lambda_u242_u24lambda_u241 = this.$this_invokeWithBody;
                                    boolean bl = false;
                                    Iterable $this$forEach$iv = this.$it$inlined.getBounds$kover_gradle_plugin();
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        String string;
                                        String string2;
                                        String string3;
                                        Map limitArgs;
                                        VerificationBound b = (VerificationBound)element$iv;
                                        boolean bl2 = false;
                                        Map map = limitArgs = (Map)new LinkedHashMap<K, V>();
                                        String string4 = "counter";
                                        switch (doJacocoVerify.WhenMappings.$EnumSwitchMapping$1[b.getMetric().ordinal()]) {
                                            case 1: {
                                                string3 = "LINE";
                                                break;
                                            }
                                            case 2: {
                                                string3 = "INSTRUCTION";
                                                break;
                                            }
                                            case 3: {
                                                string3 = "BRANCH";
                                                break;
                                            }
                                            default: {
                                                throw new NoWhenBranchMatchedException();
                                            }
                                        }
                                        Object object = string3;
                                        map.put(string4, object);
                                        BigDecimal min = b.getMinValue();
                                        BigDecimal max = b.getMaxValue();
                                        switch (doJacocoVerify.WhenMappings.$EnumSwitchMapping$2[b.getAggregation().ordinal()]) {
                                            case 1: {
                                                limitArgs.put("value", "COVEREDCOUNT");
                                                break;
                                            }
                                            case 2: {
                                                limitArgs.put("value", "MISSEDCOUNT");
                                                break;
                                            }
                                            case 3: {
                                                limitArgs.put("value", "COVEREDRATIO");
                                                BigDecimal bigDecimal = min;
                                                min = bigDecimal != null && (bigDecimal = bigDecimal.divide(UtilKt.getONE_HUNDRED())) != null ? bigDecimal.setScale(4) : null;
                                                BigDecimal bigDecimal2 = max;
                                                max = bigDecimal2 != null && (bigDecimal2 = bigDecimal2.divide(UtilKt.getONE_HUNDRED())) != null ? bigDecimal2.setScale(4) : null;
                                                break;
                                            }
                                            case 4: {
                                                limitArgs.put("value", "MISSEDRATIO");
                                                BigDecimal bigDecimal = min;
                                                min = bigDecimal != null && (bigDecimal = bigDecimal.divide(UtilKt.getONE_HUNDRED())) != null ? bigDecimal.setScale(4) : null;
                                                BigDecimal bigDecimal3 = max;
                                                BigDecimal bigDecimal4 = bigDecimal3 != null && (bigDecimal3 = bigDecimal3.divide(UtilKt.getONE_HUNDRED())) != null ? bigDecimal3.setScale(4) : (max = null);
                                            }
                                        }
                                        if (min != null) {
                                            object = limitArgs;
                                            string2 = "minimum";
                                            Intrinsics.checkNotNullExpressionValue((Object)min.toPlainString(), (String)"min.toPlainString()");
                                            object.put(string2, string);
                                        }
                                        if (max != null) {
                                            object = limitArgs;
                                            string2 = "maximum";
                                            Intrinsics.checkNotNullExpressionValue((Object)max.toPlainString(), (String)"max.toPlainString()");
                                            object.put(string2, string);
                                        }
                                        $this$invoke_u24lambda_u243_u24lambda_u242_u24lambda_u241.invokeMethod("limit", (Object)limitArgs);
                                    }
                                    return null;
                                }
                            }};
                            $this$invokeWithBody$iv.invokeMethod((String)name$iv, (Object)CollectionsKt.listOf((Object[])objectArray));
                        }
                        return null;
                    }
                }};
                $this$invokeWithBody$iv.invokeMethod((String)name$iv, (Object)CollectionsKt.listOf((Object[])objectArray));
            }
        }));
        return VerificationKt.violations((GroovyObject)$this$doJacocoVerify.getServices().getAntBuilder());
    }

    /*
     * WARNING - void declaration
     */
    private static final List<RuleViolations> violations(GroovyObject $this$violations) {
        void $this$mapTo$iv$iv;
        Object project = $this$violations.getProperty("project");
        Object object = JavaMethod.of((Object)project, Hashtable.class, (String)"getProperties", (Class[])new Class[0]).invoke(project, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"of(\n        project,\n   \u2026roject, *arrayOfNulls(0))");
        Hashtable properties = (Hashtable)object;
        String string = (String)((Map)properties).get("jacocoErrors");
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String allErrorsString = string;
        Iterable $this$map$iv = CollectionsKt.sorted((Iterable)StringsKt.lines((CharSequence)allErrorsString));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MatchResult match;
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (Regex.find$default((Regex)errorMessageRegex, (CharSequence)((CharSequence)it), (int)0, (int)2, null) == null) {
                throw new KoverCriticalException("Can't parse JaCoCo verification error string:\n" + (String)it, null, 2, null);
            }
            GroupingEntityType entityType = VerificationKt.asEntityType((String)match.getGroupValues().get(1), (String)it);
            String $this$violations_u24lambda_u241_u24lambda_u240 = (String)match.getGroupValues().get(2);
            boolean bl2 = false;
            String entityName = Intrinsics.areEqual((Object)$this$violations_u24lambda_u241_u24lambda_u240, (Object)":") ? null : $this$violations_u24lambda_u241_u24lambda_u240;
            MetricType metric = VerificationKt.asMetricType((String)match.getGroupValues().get(3), (String)it);
            AggregationType agg = VerificationKt.asAggType((String)match.getGroupValues().get(4), (String)it);
            BigDecimal value = VerificationKt.asValue((String)match.getGroupValues().get(5), (String)it, agg);
            boolean isMax = VerificationKt.asIsMax((String)match.getGroupValues().get(6), (String)it);
            BigDecimal expected = VerificationKt.asValue((String)match.getGroupValues().get(7), (String)it, agg);
            collection.add(new RuleViolations(entityType, CollectionsKt.listOf((Object)new BoundViolations(isMax, expected, value, metric, agg, entityName)), null, 4, null));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private static final GroupingEntityType asEntityType(String $this$asEntityType, String line) {
        GroupingEntityType groupingEntityType;
        switch ($this$asEntityType) {
            case "bundle": {
                groupingEntityType = GroupingEntityType.APPLICATION;
                break;
            }
            case "class": {
                groupingEntityType = GroupingEntityType.CLASS;
                break;
            }
            case "package": {
                groupingEntityType = GroupingEntityType.PACKAGE;
                break;
            }
            default: {
                throw new KoverCriticalException("Unknown JaCoCo entity type '" + $this$asEntityType + "' in verification error:\n" + line, null, 2, null);
            }
        }
        return groupingEntityType;
    }

    private static final MetricType asMetricType(String $this$asMetricType, String line) {
        MetricType metricType;
        switch ($this$asMetricType) {
            case "lines": {
                metricType = MetricType.LINE;
                break;
            }
            case "instructions": {
                metricType = MetricType.INSTRUCTION;
                break;
            }
            case "branches": {
                metricType = MetricType.BRANCH;
                break;
            }
            default: {
                throw new KoverCriticalException("Unknown JaCoCo metric type '" + $this$asMetricType + "' in verification error:\n" + line, null, 2, null);
            }
        }
        return metricType;
    }

    private static final AggregationType asAggType(String $this$asAggType, String line) {
        AggregationType aggregationType;
        switch ($this$asAggType) {
            case "covered ratio": {
                aggregationType = AggregationType.COVERED_PERCENTAGE;
                break;
            }
            case "missed ratio": {
                aggregationType = AggregationType.MISSED_PERCENTAGE;
                break;
            }
            case "covered count": {
                aggregationType = AggregationType.COVERED_COUNT;
                break;
            }
            case "missed count": {
                aggregationType = AggregationType.MISSED_COUNT;
                break;
            }
            default: {
                throw new KoverCriticalException("Unknown JaCoCo aggregation type '" + $this$asAggType + "' in verification error:\n" + line, null, 2, null);
            }
        }
        return aggregationType;
    }

    private static final boolean asIsMax(String $this$asIsMax, String line) {
        boolean bl;
        String string = $this$asIsMax;
        if (Intrinsics.areEqual((Object)string, (Object)"minimum")) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)string, (Object)"maximum")) {
            bl = true;
        } else {
            throw new KoverCriticalException("Unknown JaCoCo direction '" + $this$asIsMax + "' in verification error:\n" + line, null, 2, null);
        }
        return bl;
    }

    private static final BigDecimal asValue(String $this$asValue, String line, AggregationType aggregationType) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = StringsKt.toBigDecimalOrNull((String)$this$asValue);
        if (bigDecimal2 == null) {
            throw new KoverCriticalException("Illegal JaCoCo metric value '" + $this$asValue + "' in verification error:\n" + line, null, 2, null);
        }
        BigDecimal value = bigDecimal2;
        if (aggregationType.isPercentage()) {
            BigDecimal bigDecimal3 = value.multiply(UtilKt.getONE_HUNDRED());
            bigDecimal = bigDecimal3;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"this.multiply(other)");
        } else {
            bigDecimal = value;
        }
        return bigDecimal;
    }
}

