/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.aggregation.project.instrumentation;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.aggregation.project.instrumentation.InstrumentationFilter;
import kotlinx.kover.gradle.aggregation.project.instrumentation.JvmTestTaskInstrumentationKt;
import org.gradle.api.Named;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001d\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0017R\u0013\u0010\u0007\u001a\u00020\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0005\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkotlinx/kover/gradle/aggregation/project/instrumentation/JvmTestTaskArgumentProvider;", "Lorg/gradle/process/CommandLineArgumentProvider;", "Lorg/gradle/api/Named;", "tempDir", "Ljava/io/File;", "jarFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "filter", "Lkotlinx/kover/gradle/aggregation/project/instrumentation/InstrumentationFilter;", "reportProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "(Ljava/io/File;Lorg/gradle/api/file/ConfigurableFileCollection;Lkotlinx/kover/gradle/aggregation/project/instrumentation/InstrumentationFilter;Lorg/gradle/api/provider/Provider;)V", "getFilter", "()Lkotlinx/kover/gradle/aggregation/project/instrumentation/InstrumentationFilter;", "getJarFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "getReportProvider", "()Lorg/gradle/api/provider/Provider;", "asArguments", "", "", "getName", "kover-gradle-plugin"})
final class JvmTestTaskArgumentProvider
implements CommandLineArgumentProvider,
Named {
    @NotNull
    private final File tempDir;
    @NotNull
    private final ConfigurableFileCollection jarFiles;
    @NotNull
    private final InstrumentationFilter filter;
    @NotNull
    private final Provider<RegularFile> reportProvider;

    public JvmTestTaskArgumentProvider(@NotNull File tempDir, @NotNull ConfigurableFileCollection jarFiles, @NotNull InstrumentationFilter filter, @NotNull Provider<RegularFile> reportProvider) {
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)jarFiles, (String)"jarFiles");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter(reportProvider, (String)"reportProvider");
        this.tempDir = tempDir;
        this.jarFiles = jarFiles;
        this.filter = filter;
        this.reportProvider = reportProvider;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final ConfigurableFileCollection getJarFiles() {
        return this.jarFiles;
    }

    @Nested
    @NotNull
    public final InstrumentationFilter getFilter() {
        return this.filter;
    }

    @OutputFile
    @NotNull
    public final Provider<RegularFile> getReportProvider() {
        return this.reportProvider;
    }

    @Internal
    @NotNull
    public String getName() {
        return "koverArgumentsProvider";
    }

    @NotNull
    public Iterable<String> asArguments() {
        Set set = this.jarFiles.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"jarFiles.files");
        Set files = set;
        if (files.size() != 1) {
            return new LinkedHashSet();
        }
        File jarFile = (File)CollectionsKt.single((Iterable)files);
        Intrinsics.checkNotNullExpressionValue((Object)jarFile, (String)"jarFile");
        File file = ((RegularFile)this.reportProvider.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"reportProvider.get().asFile");
        return CollectionsKt.toMutableList((Collection)JvmTestTaskInstrumentationKt.access$buildKoverJvmAgentArgs(jarFile, this.tempDir, file, this.filter.getExcludes()));
    }
}

