/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.aggregation.settings.tasks;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.features.jvm.ClassFilters;
import kotlinx.kover.features.jvm.KoverLegacyFeatures;
import kotlinx.kover.gradle.aggregation.settings.tasks.AbstractKoverTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b!\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\u0006\u0010\u0011\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lkotlinx/kover/gradle/aggregation/settings/tasks/KoverHtmlReportTask;", "Lkotlinx/kover/gradle/aggregation/settings/tasks/AbstractKoverTask;", "()V", "charset", "Lorg/gradle/api/provider/Property;", "", "getCharset", "()Lorg/gradle/api/provider/Property;", "htmlDir", "Lorg/gradle/api/file/DirectoryProperty;", "getHtmlDir", "()Lorg/gradle/api/file/DirectoryProperty;", "projectPath", "title", "getTitle", "generate", "", "printPath", "kover-gradle-plugin"})
public abstract class KoverHtmlReportTask
extends AbstractKoverTask {
    @NotNull
    private final String projectPath;

    public KoverHtmlReportTask() {
        String string = this.getProject().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
        this.projectPath = string;
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getHtmlDir();

    @Input
    @NotNull
    public abstract Property<String> getTitle();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getCharset();

    @TaskAction
    public final void generate() {
        Object object = this.getHtmlDir().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"htmlDir.asFile.get()");
        File file = (File)object;
        String string = (String)this.getCharset().getOrNull();
        List<File> list = this.getReports();
        List<File> list2 = this.getOutputs();
        List<File> list3 = this.getSources();
        Object object2 = this.getTitle().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"title.get()");
        String string2 = (String)object2;
        Object object3 = this.getIncludedClasses().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"includedClasses.get()");
        Set set = (Set)object3;
        Object object4 = this.getExcludedClasses().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"excludedClasses.get()");
        KoverLegacyFeatures.INSTANCE.generateHtmlReport(file, string, list, list2, list3, string2, new ClassFilters(set, (Set)object4, SetsKt.emptySet(), SetsKt.emptySet(), SetsKt.emptySet(), SetsKt.emptySet()));
    }

    public final void printPath() {
        String clickablePath = new URI("file", "", new File(((Directory)this.getHtmlDir().get()).getAsFile().getCanonicalPath(), "index.html").toURI().getPath(), null, null).toASCIIString();
        this.getLogger().lifecycle("Kover: HTML report for '" + this.projectPath + "' " + clickablePath);
    }
}

