/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.appliers.instrumentation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import kotlinx.kover.gradle.plugin.tools.CoverageToolVariant;
import org.gradle.api.Named;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001d\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002BY\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0006\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0016J\b\u0010\u001c\u001a\u00020\rH\u0017R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001f\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lkotlinx/kover/gradle/plugin/appliers/instrumentation/JvmTestTaskArgumentProvider;", "Lorg/gradle/process/CommandLineArgumentProvider;", "Lorg/gradle/api/Named;", "tempDir", "Ljava/io/File;", "toolProvider", "Lorg/gradle/api/provider/Provider;", "Lkotlinx/kover/gradle/plugin/tools/CoverageTool;", "agentJar", "instrumentationDisabled", "", "excludedClasses", "", "", "reportProvider", "Lorg/gradle/api/file/RegularFile;", "(Ljava/io/File;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;)V", "getAgentJar", "()Lorg/gradle/api/provider/Provider;", "getExcludedClasses", "getInstrumentationDisabled", "getReportProvider", "toolVariant", "Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "getToolVariant", "()Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "asArguments", "", "getName", "kover-gradle-plugin"})
final class JvmTestTaskArgumentProvider
implements CommandLineArgumentProvider,
Named {
    @NotNull
    private final File tempDir;
    @NotNull
    private final Provider<CoverageTool> toolProvider;
    @NotNull
    private final Provider<File> agentJar;
    @NotNull
    private final Provider<Boolean> instrumentationDisabled;
    @NotNull
    private final Provider<Set<String>> excludedClasses;
    @NotNull
    private final Provider<RegularFile> reportProvider;

    public JvmTestTaskArgumentProvider(@NotNull File tempDir, @NotNull Provider<CoverageTool> toolProvider, @NotNull Provider<File> agentJar, @NotNull Provider<Boolean> instrumentationDisabled, @NotNull Provider<Set<String>> excludedClasses, @NotNull Provider<RegularFile> reportProvider) {
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter(toolProvider, (String)"toolProvider");
        Intrinsics.checkNotNullParameter(agentJar, (String)"agentJar");
        Intrinsics.checkNotNullParameter(instrumentationDisabled, (String)"instrumentationDisabled");
        Intrinsics.checkNotNullParameter(excludedClasses, (String)"excludedClasses");
        Intrinsics.checkNotNullParameter(reportProvider, (String)"reportProvider");
        this.tempDir = tempDir;
        this.toolProvider = toolProvider;
        this.agentJar = agentJar;
        this.instrumentationDisabled = instrumentationDisabled;
        this.excludedClasses = excludedClasses;
        this.reportProvider = reportProvider;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final Provider<File> getAgentJar() {
        return this.agentJar;
    }

    @Input
    @NotNull
    public final Provider<Boolean> getInstrumentationDisabled() {
        return this.instrumentationDisabled;
    }

    @Input
    @NotNull
    public final Provider<Set<String>> getExcludedClasses() {
        return this.excludedClasses;
    }

    @OutputFile
    @NotNull
    public final Provider<RegularFile> getReportProvider() {
        return this.reportProvider;
    }

    @Nested
    @NotNull
    public final CoverageToolVariant getToolVariant() {
        return ((CoverageTool)this.toolProvider.get()).getVariant();
    }

    @Internal
    @NotNull
    public String getName() {
        return "koverArgumentsProvider";
    }

    @NotNull
    public Iterable<String> asArguments() {
        Iterable iterable;
        if (!((Boolean)this.instrumentationDisabled.get()).booleanValue()) {
            CoverageTool coverageTool = (CoverageTool)this.toolProvider.get();
            Object object = this.agentJar.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"agentJar.get()");
            File file = (File)object;
            File file2 = ((RegularFile)this.reportProvider.get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"reportProvider.get().asFile");
            Object object2 = this.excludedClasses.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"excludedClasses.get()");
            iterable = CollectionsKt.toMutableList((Collection)coverageTool.jvmAgentArgs(file, this.tempDir, file2, (Set)object2));
        } else {
            iterable = new ArrayList();
        }
        return iterable;
    }
}

