/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tasks.reports;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.dsl.tasks.KoverBinaryReport;
import kotlinx.kover.gradle.plugin.tasks.reports.AbstractKoverReportTask;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b!\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0007R\u0014\u0010\u0006\u001a\u00020\u00078aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0003\u001a\u00020\u00048\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lkotlinx/kover/gradle/plugin/tasks/reports/KoverBinaryTask;", "Lkotlinx/kover/gradle/plugin/tasks/reports/AbstractKoverReportTask;", "Lkotlinx/kover/gradle/plugin/dsl/tasks/KoverBinaryReport;", "variantName", "", "(Ljava/lang/String;)V", "file", "Lorg/gradle/api/file/RegularFileProperty;", "getFile$kover_gradle_plugin", "()Lorg/gradle/api/file/RegularFileProperty;", "getVariantName", "()Ljava/lang/String;", "generate", "", "kover-gradle-plugin"})
public abstract class KoverBinaryTask
extends AbstractKoverReportTask
implements KoverBinaryReport {
    @NotNull
    private final String variantName;

    @Inject
    public KoverBinaryTask(@NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        this.variantName = variantName;
    }

    @Override
    @Internal
    @NotNull
    public String getVariantName() {
        return this.variantName;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getFile$kover_gradle_plugin();

    @TaskAction
    public final void generate() {
        File file = ((RegularFile)this.getFile$kover_gradle_plugin().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file.get().asFile");
        File binary = file;
        binary.getParentFile().mkdirs();
        ((CoverageTool)this.getTool().get()).binaryReport(binary, this.context());
    }
}

