/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.aggregation.project.tasks;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.kover.gradle.aggregation.commons.artifacts.ArtifactSerializer;
import kotlinx.kover.gradle.aggregation.commons.artifacts.CompilationInfo;
import kotlinx.kover.gradle.aggregation.commons.artifacts.ProjectArtifactInfo;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="There are no heavy computations")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b!\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0016\u001a\u00020\u0017H\u0001\u00a2\u0006\u0002\b\u0018R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u00058AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkotlinx/kover/gradle/aggregation/project/tasks/ArtifactGenerationTask;", "Lorg/gradle/api/DefaultTask;", "()V", "compilations", "Lorg/gradle/api/provider/MapProperty;", "", "Lkotlinx/kover/gradle/aggregation/commons/artifacts/CompilationInfo;", "getCompilations", "()Lorg/gradle/api/provider/MapProperty;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile$kover_gradle_plugin", "()Lorg/gradle/api/file/RegularFileProperty;", "projectPath", "getProjectPath$kover_gradle_plugin", "()Ljava/lang/String;", "reportFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getReportFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "rootDir", "Ljava/io/File;", "generate", "", "generate$kover_gradle_plugin", "kover-gradle-plugin"})
public abstract class ArtifactGenerationTask
extends DefaultTask {
    @NotNull
    private final String projectPath;
    @NotNull
    private final File rootDir;

    public ArtifactGenerationTask() {
        String string = this.getProject().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
        this.projectPath = string;
        File file = this.getProject().getRootDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootDir");
        this.rootDir = file;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile$kover_gradle_plugin();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getReportFiles();

    @Nested
    @NotNull
    public abstract MapProperty<String, CompilationInfo> getCompilations();

    @Input
    @NotNull
    public final String getProjectPath$kover_gradle_plugin() {
        return this.projectPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void generate$kover_gradle_plugin() {
        File file = ((RegularFile)this.getOutputFile$kover_gradle_plugin().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputFile.get().asFile");
        File file2 = file;
        file2.getParentFile().mkdirs();
        Set set = this.getReportFiles().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"reportFiles.files");
        Collection collection = set;
        Object object = this.getCompilations().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compilations.get()");
        ProjectArtifactInfo projectInfo = new ProjectArtifactInfo(this.projectPath, collection, (Map)object);
        Object object2 = file2;
        Object object3 = Charsets.UTF_8;
        int n = 8192;
        Object object4 = object2;
        object4 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object4), (Charset)object3);
        object2 = object4 instanceof BufferedWriter ? (BufferedWriter)object4 : new BufferedWriter((Writer)object4, n);
        object3 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object2;
            boolean bl = false;
            ArtifactSerializer.INSTANCE.serialize(writer, this.rootDir, projectInfo);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
    }
}

