/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.aggregation.project.instrumentation;

import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.aggregation.commons.names.KoverPaths;
import kotlinx.kover.gradle.aggregation.project.instrumentation.InstrumentationFilter;
import kotlinx.kover.gradle.aggregation.project.instrumentation.JvmTestTaskArgumentProvider;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.testing.Test;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lkotlinx/kover/gradle/aggregation/project/instrumentation/JvmOnFlyInstrumenter;", "", "()V", "instrument", "", "tasks", "Lorg/gradle/api/tasks/TaskCollection;", "Lorg/gradle/api/tasks/testing/Test;", "jarConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "filter", "Lkotlinx/kover/gradle/aggregation/project/instrumentation/InstrumentationFilter;", "kover-gradle-plugin"})
public final class JvmOnFlyInstrumenter {
    @NotNull
    public static final JvmOnFlyInstrumenter INSTANCE = new JvmOnFlyInstrumenter();

    private JvmOnFlyInstrumenter() {
    }

    public final void instrument(@NotNull TaskCollection<Test> tasks, @NotNull Configuration jarConfiguration, @NotNull InstrumentationFilter filter) {
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        Intrinsics.checkNotNullParameter((Object)jarConfiguration, (String)"jarConfiguration");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        tasks.configureEach(new Action(filter, jarConfiguration){
            final /* synthetic */ InstrumentationFilter $filter;
            final /* synthetic */ Configuration $jarConfiguration;
            {
                this.$filter = $filter;
                this.$jarConfiguration = $jarConfiguration;
            }

            public final void execute(@NotNull Test $this$configureEach) {
                Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                Provider provider = $this$configureEach.getProject().getLayout().getBuildDirectory().map(new Transformer($this$configureEach){
                    final /* synthetic */ Test $this_configureEach;
                    {
                        this.$this_configureEach = $this_configureEach;
                    }

                    public final RegularFile transform(@NotNull Directory dir) {
                        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                        String string = this.$this_configureEach.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                        return dir.file(KoverPaths.INSTANCE.binReportPath$kover_gradle_plugin(string));
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"{\n            val binRep\u2026r\n            )\n        }");
                Provider binReportProvider2 = provider;
                $this$configureEach.doFirst(new Action((Provider<RegularFile>)binReportProvider2){
                    final /* synthetic */ Provider<RegularFile> $binReportProvider;
                    {
                        this.$binReportProvider = $binReportProvider;
                    }

                    public final void execute(@NotNull Task $this$doFirst) {
                        Intrinsics.checkNotNullParameter((Object)$this$doFirst, (String)"$this$doFirst");
                        ((RegularFile)this.$binReportProvider.get()).getAsFile().delete();
                    }
                });
                Object[] objectArray = new String[]{"android.*", "com.android.*", "jdk.internal.*"};
                Set androidClasses = SetsKt.setOf((Object[])objectArray);
                InstrumentationFilter excludedClassesWithAndroid2 = InstrumentationFilter.copy$default(this.$filter, null, SetsKt.plus(this.$filter.getExcludes(), (Iterable)androidClasses), 1, null);
                Object object = new Object[]{this.$jarConfiguration};
                $this$configureEach.dependsOn((Object[])object);
                List list = $this$configureEach.getJvmArgumentProviders();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jvmArgumentProviders");
                object = list;
                File file = $this$configureEach.getTemporaryDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"temporaryDir");
                Object[] objectArray2 = new Object[]{this.$jarConfiguration};
                ConfigurableFileCollection configurableFileCollection = $this$configureEach.getProject().getObjects().fileCollection().from(objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.fileColl\u2026().from(jarConfiguration)");
                object.add(new JvmTestTaskArgumentProvider(file, configurableFileCollection, excludedClassesWithAndroid2, (Provider<RegularFile>)binReportProvider2));
            }
        });
    }
}

