/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.appliers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.kover.gradle.plugin.appliers.KoverContext;
import kotlinx.kover.gradle.plugin.commons.KoverIllegalConfigException;
import kotlinx.kover.gradle.plugin.dsl.KoverMergingInstrumentation;
import kotlinx.kover.gradle.plugin.dsl.KoverMergingVariantCreate;
import kotlinx.kover.gradle.plugin.dsl.KoverMergingVariantSources;
import kotlinx.kover.gradle.plugin.dsl.KoverProjectInstrumentation;
import kotlinx.kover.gradle.plugin.dsl.KoverVariantCreateConfig;
import kotlinx.kover.gradle.plugin.dsl.KoverVariantSources;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverMergingConfigImpl;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverProjectExtensionImpl;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001a\u0010\u0007\u001a\u00020\u0001*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0002\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\bH\u0000\u001a\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\n*\u00020\bH\u0002\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\r\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\r\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a8\u0006\u0015"}, d2={"configBeforeFinalize", "", "Lkotlinx/kover/gradle/plugin/dsl/internal/KoverProjectExtensionImpl;", "targetProject", "Lorg/gradle/api/Project;", "applyJacoco", "", "configSelectedProjects", "Lkotlinx/kover/gradle/plugin/appliers/KoverContext;", "targetProjects", "", "prepareMerging", "selectProjects", "wrap", "Lkotlinx/kover/gradle/plugin/dsl/KoverMergingInstrumentation;", "Lkotlinx/kover/gradle/plugin/dsl/KoverProjectInstrumentation;", "project", "Lkotlinx/kover/gradle/plugin/dsl/KoverMergingVariantCreate;", "Lkotlinx/kover/gradle/plugin/dsl/KoverVariantCreateConfig;", "Lkotlinx/kover/gradle/plugin/dsl/KoverMergingVariantSources;", "Lkotlinx/kover/gradle/plugin/dsl/KoverVariantSources;", "kover-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nKoverMerge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoverMerge.kt\nkotlinx/kover/gradle/plugin/appliers/KoverMergeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1855#2,2:126\n1855#2,2:128\n1855#2,2:130\n1747#2,3:132\n*S KotlinDebug\n*F\n+ 1 KoverMerge.kt\nkotlinx/kover/gradle/plugin/appliers/KoverMergeKt\n*L\n46#1:126,2\n49#1:128,2\n59#1:130,2\n31#1:132,3\n*E\n"})
public final class KoverMergeKt {
    public static final void prepareMerging(@NotNull KoverContext $this$prepareMerging) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareMerging, (String)"<this>");
        if (!$this$prepareMerging.getProjectExtension().getMerge().getConfigured$kover_gradle_plugin()) {
            return;
        }
        List<Project> projects2 = KoverMergeKt.selectProjects($this$prepareMerging);
        KoverMergeKt.configSelectedProjects($this$prepareMerging, projects2);
    }

    private static final List<Project> selectProjects(KoverContext $this$selectProjects) {
        Project subproject;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)$this$selectProjects.getProject().getPath(), (Object)$this$selectProjects.getProject())};
        LinkedHashMap result = MapsKt.linkedMapOf((Pair[])pairArray);
        KoverMergingConfigImpl mergeConfig = $this$selectProjects.getProjectExtension().getMerge();
        List<Spec<Project>> subprojectsFilters = mergeConfig.getSubprojectsFilters$kover_gradle_plugin();
        List<Spec<Project>> allProjectsFilters = mergeConfig.getAllProjectsFilters$kover_gradle_plugin();
        if (subprojectsFilters.isEmpty() && allProjectsFilters.isEmpty()) {
            throw new KoverIllegalConfigException("No projects have been specified to be used in the merged report in '" + $this$selectProjects.getProject().getPath() + "'. Please specify 'subprojects()', 'projects()', or 'allProjects()' in 'merge {}' block or delete this block.");
        }
        Set set = $this$selectProjects.getProject().getSubprojects();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.subprojects");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            subproject = (Project)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)subproject, (String)"subproject");
            KoverMergeKt.selectProjects$addProjectIfFiltered(result, subproject, subprojectsFilters);
        }
        Set set2 = $this$selectProjects.getProject().getRootProject().getAllprojects();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"project.rootProject.allprojects");
        $this$forEach$iv = set2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            subproject = (Project)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)subproject, (String)"subproject");
            KoverMergeKt.selectProjects$addProjectIfFiltered(result, subproject, allProjectsFilters);
        }
        Collection collection = result.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"result.values");
        return CollectionsKt.toList((Iterable)collection);
    }

    private static final void configSelectedProjects(KoverContext $this$configSelectedProjects, List<? extends Project> targetProjects) {
        KoverProjectExtensionImpl koverExtension = $this$configSelectedProjects.getProjectExtension();
        Iterable $this$forEach$iv = targetProjects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project targetProject = (Project)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)targetProject.getPath(), (Object)$this$configSelectedProjects.getProject().getPath())) {
                targetProject.getPluginManager().apply("org.jetbrains.kotlinx.kover");
                $this$configSelectedProjects.getProject().getDependencies().add($this$configSelectedProjects.getKoverBucketConfiguration().getName(), (Object)targetProject);
                KoverMergeKt.configBeforeFinalize$default(koverExtension, targetProject, false, 2, null);
                continue;
            }
            KoverMergeKt.configBeforeFinalize(koverExtension, targetProject, false);
        }
    }

    private static final void configBeforeFinalize(KoverProjectExtensionImpl $this$configBeforeFinalize, Project targetProject, boolean applyJacoco) {
        Object object = targetProject.getExtensions().getByType(KoverProjectExtensionImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"targetProject.extensions\u2026xtensionImpl::class.java)");
        KoverProjectExtensionImpl targetExtension = (KoverProjectExtensionImpl)object;
        targetExtension.beforeFinalize$kover_gradle_plugin((Function0<Unit>)((Function0)new Function0<Unit>(applyJacoco, targetExtension, $this$configBeforeFinalize, targetProject){
            final /* synthetic */ boolean $applyJacoco;
            final /* synthetic */ KoverProjectExtensionImpl $targetExtension;
            final /* synthetic */ KoverProjectExtensionImpl $this_configBeforeFinalize;
            final /* synthetic */ Project $targetProject;
            {
                this.$applyJacoco = $applyJacoco;
                this.$targetExtension = $targetExtension;
                this.$this_configBeforeFinalize = $receiver;
                this.$targetProject = $targetProject;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                if (this.$applyJacoco) {
                    this.$targetExtension.getUseJacoco().set((Provider)this.$this_configBeforeFinalize.getUseJacoco());
                    this.$targetExtension.getJacocoVersion().set((Provider)this.$this_configBeforeFinalize.getJacocoVersion());
                }
                Action<KoverMergingVariantSources> action = this.$this_configBeforeFinalize.getMerge().getSourcesAction$kover_gradle_plugin();
                if (action != null) {
                    action.execute((Object)KoverMergeKt.access$wrap(this.$targetExtension.getCurrentProject().getSources(), this.$targetProject));
                }
                Action<KoverMergingInstrumentation> action2 = this.$this_configBeforeFinalize.getMerge().getInstrumentationAction$kover_gradle_plugin();
                if (action2 != null) {
                    action2.execute((Object)KoverMergeKt.access$wrap(this.$targetExtension.getCurrentProject().getInstrumentation(), this.$targetProject));
                }
                Map<String, Action<KoverMergingVariantCreate>> map = this.$this_configBeforeFinalize.getMerge().getVariantsAction$kover_gradle_plugin();
                KoverProjectExtensionImpl koverProjectExtensionImpl = this.$targetExtension;
                Project project = this.$targetProject;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> entry = element$iv = iterator.next();
                    boolean bl = false;
                    String variantName = (String)entry.getKey();
                    Action action3 = (Action)entry.getValue();
                    koverProjectExtensionImpl.getCurrentProject().createVariant(variantName, (Action<KoverVariantCreateConfig>)new Action((Action<KoverMergingVariantCreate>)action3, project){
                        final /* synthetic */ Action<KoverMergingVariantCreate> $action;
                        final /* synthetic */ Project $targetProject;
                        {
                            this.$action = $action;
                            this.$targetProject = $targetProject;
                        }

                        public final void execute(@NotNull KoverVariantCreateConfig $this$createVariant) {
                            Intrinsics.checkNotNullParameter((Object)$this$createVariant, (String)"$this$createVariant");
                            this.$action.execute((Object)KoverMergeKt.access$wrap($this$createVariant, this.$targetProject));
                        }
                    });
                }
            }
        }));
    }

    static /* synthetic */ void configBeforeFinalize$default(KoverProjectExtensionImpl koverProjectExtensionImpl, Project project, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        KoverMergeKt.configBeforeFinalize(koverProjectExtensionImpl, project, bl);
    }

    private static final KoverMergingVariantSources wrap(KoverVariantSources $this$wrap, Project project) {
        return new KoverMergingVariantSources($this$wrap, project){
            @NotNull
            private final Property<Boolean> excludeJava;
            @NotNull
            private final SetProperty<String> excludedSourceSets;
            @NotNull
            private final Project project;
            {
                this.excludeJava = $receiver.getExcludeJava();
                this.excludedSourceSets = $receiver.getExcludedSourceSets();
                this.project = $project;
            }

            @NotNull
            public Property<Boolean> getExcludeJava() {
                return this.excludeJava;
            }

            @NotNull
            public SetProperty<String> getExcludedSourceSets() {
                return this.excludedSourceSets;
            }

            @NotNull
            public Project getProject() {
                return this.project;
            }
        };
    }

    private static final KoverMergingInstrumentation wrap(KoverProjectInstrumentation $this$wrap, Project project) {
        return new KoverMergingInstrumentation($this$wrap, project){
            @NotNull
            private final Property<Boolean> disabledForAll;
            @NotNull
            private final SetProperty<String> disabledForTestTasks;
            @NotNull
            private final SetProperty<String> excludedClasses;
            @NotNull
            private final SetProperty<String> includedClasses;
            @NotNull
            private final Project project;
            {
                this.disabledForAll = $receiver.getDisabledForAll();
                this.disabledForTestTasks = $receiver.getDisabledForTestTasks();
                this.excludedClasses = $receiver.getExcludedClasses();
                this.includedClasses = $receiver.getIncludedClasses();
                this.project = $project;
            }

            @NotNull
            public Property<Boolean> getDisabledForAll() {
                return this.disabledForAll;
            }

            @NotNull
            public SetProperty<String> getDisabledForTestTasks() {
                return this.disabledForTestTasks;
            }

            @NotNull
            public SetProperty<String> getExcludedClasses() {
                return this.excludedClasses;
            }

            @NotNull
            public SetProperty<String> getIncludedClasses() {
                return this.includedClasses;
            }

            @NotNull
            public Project getProject() {
                return this.project;
            }
        };
    }

    private static final KoverMergingVariantCreate wrap(KoverVariantCreateConfig $this$wrap, Project project) {
        return new KoverMergingVariantCreate($this$wrap, project){
            @NotNull
            private final KoverVariantSources sources;
            @NotNull
            private final Project project;
            final /* synthetic */ KoverVariantCreateConfig $this_wrap;
            {
                this.$this_wrap = $receiver;
                this.sources = $receiver.getSources();
                this.project = $project;
            }

            @NotNull
            public KoverVariantSources getSources() {
                return this.sources;
            }

            public void sources(@NotNull Action<KoverVariantSources> block) {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                this.$this_wrap.sources(block);
            }

            public void add(@NotNull String[] variantNames, boolean optional) {
                Intrinsics.checkNotNullParameter((Object)variantNames, (String)"variantNames");
                this.$this_wrap.add(Arrays.copyOf(variantNames, variantNames.length), optional);
            }

            public void addWithDependencies(@NotNull String[] variantNames, boolean optional) {
                Intrinsics.checkNotNullParameter((Object)variantNames, (String)"variantNames");
                this.$this_wrap.addWithDependencies(Arrays.copyOf(variantNames, variantNames.length), optional);
            }

            public void add(@NotNull Iterable<String> variantNames, boolean optional) {
                Intrinsics.checkNotNullParameter(variantNames, (String)"variantNames");
                this.$this_wrap.add(variantNames, optional);
            }

            public void addWithDependencies(@NotNull Iterable<String> variantNames, boolean optional) {
                Intrinsics.checkNotNullParameter(variantNames, (String)"variantNames");
                this.$this_wrap.addWithDependencies(variantNames, optional);
            }

            @NotNull
            public Project getProject() {
                return this.project;
            }
        };
    }

    private static final void selectProjects$addProjectIfFiltered(LinkedHashMap<String, Project> result, Project project, List<? extends Spec<Project>> filters) {
        boolean pass;
        block5: {
            boolean bl;
            if (result.containsKey(project.getPath())) {
                return;
            }
            Iterable $this$any$iv = filters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Spec it = (Spec)element$iv;
                    boolean bl2 = false;
                    if (!it.isSatisfiedBy((Object)project)) continue;
                    bl = true;
                    break block5;
                }
                bl = pass = false;
            }
        }
        if (pass) {
            ((Map)result).put(project.getPath(), project);
        }
    }

    public static final /* synthetic */ KoverMergingVariantSources access$wrap(KoverVariantSources $receiver, Project project) {
        return KoverMergeKt.wrap($receiver, project);
    }

    public static final /* synthetic */ KoverMergingInstrumentation access$wrap(KoverProjectInstrumentation $receiver, Project project) {
        return KoverMergeKt.wrap($receiver, project);
    }

    public static final /* synthetic */ KoverMergingVariantCreate access$wrap(KoverVariantCreateConfig $receiver, Project project) {
        return KoverMergeKt.wrap($receiver, project);
    }
}

