/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tools.jacoco;

import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.commons.ReportContext;
import kotlinx.kover.gradle.plugin.commons.VerificationRule;
import kotlinx.kover.gradle.plugin.tools.CoverageRequest;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import kotlinx.kover.gradle.plugin.tools.CoverageToolVariant;
import kotlinx.kover.gradle.plugin.tools.jacoco.JacocoHtmlOrXmlReportKt;
import kotlinx.kover.gradle.plugin.tools.jacoco.JacocoOnlineInstrumentationKt;
import kotlinx.kover.gradle.plugin.tools.jacoco.JacocoTool;
import kotlinx.kover.gradle.plugin.tools.jacoco.PrintCoverageKt;
import kotlinx.kover.gradle.plugin.tools.jacoco.VerificationKt;
import org.gradle.api.GradleException;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J*\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JB\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060#2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060(H\u0016J&\u0010*\u001a\u00020\u00102\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0#2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00060"}, d2={"Lkotlinx/kover/gradle/plugin/tools/jacoco/JacocoTool;", "Lkotlinx/kover/gradle/plugin/tools/CoverageTool;", "variant", "Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "(Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;)V", "jvmAgentDependency", "", "getJvmAgentDependency", "()Ljava/lang/String;", "jvmReporterDependency", "getJvmReporterDependency", "jvmReporterExtraDependency", "getJvmReporterExtraDependency", "getVariant", "()Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "binaryReport", "", "binary", "Ljava/io/File;", "context", "Lkotlinx/kover/gradle/plugin/commons/ReportContext;", "collectCoverage", "request", "Lkotlinx/kover/gradle/plugin/tools/CoverageRequest;", "outputFile", "findJvmAgentJar", "classpath", "Lorg/gradle/api/file/FileCollection;", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "htmlReport", "htmlDir", "title", "charset", "jvmAgentArgs", "", "jarFile", "tempDir", "binReportFile", "excludedClasses", "", "includedClasses", "verify", "rules", "Lkotlinx/kover/gradle/plugin/commons/VerificationRule;", "output", "xmlReport", "xmlFile", "kover-gradle-plugin"})
public final class JacocoTool
implements CoverageTool {
    @NotNull
    private final CoverageToolVariant variant;
    @NotNull
    private final String jvmAgentDependency;
    @NotNull
    private final String jvmReporterDependency;
    @NotNull
    private final String jvmReporterExtraDependency;

    public JacocoTool(@NotNull CoverageToolVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.variant = variant;
        this.jvmAgentDependency = "org.jacoco:org.jacoco.agent:" + this.getVariant().getVersion();
        this.jvmReporterDependency = "org.jacoco:org.jacoco.report:" + this.getVariant().getVersion();
        this.jvmReporterExtraDependency = "org.jacoco:org.jacoco.report:" + this.getVariant().getVersion();
    }

    @Override
    @NotNull
    public CoverageToolVariant getVariant() {
        return this.variant;
    }

    @Override
    @NotNull
    public String getJvmAgentDependency() {
        return this.jvmAgentDependency;
    }

    @Override
    @NotNull
    public String getJvmReporterDependency() {
        return this.jvmReporterDependency;
    }

    @Override
    @NotNull
    public String getJvmReporterExtraDependency() {
        return this.jvmReporterExtraDependency;
    }

    @Override
    @NotNull
    public File findJvmAgentJar(@NotNull FileCollection classpath, @NotNull ArchiveOperations archiveOperations) {
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)archiveOperations, (String)"archiveOperations");
        File file = classpath.filter((Spec)findJvmAgentJar.fatJar.1.INSTANCE).getSingleFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"classpath.filter { it.na\u2026coco.agent\") }.singleFile");
        File fatJar2 = file;
        File file2 = archiveOperations.zipTree((Object)fatJar2).filter((Spec)findJvmAgentJar.1.INSTANCE).getSingleFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"archiveOperations.zipTre\u2026coagent.jar\" }.singleFile");
        return file2;
    }

    @Override
    @NotNull
    public List<String> jvmAgentArgs(@NotNull File jarFile, @NotNull File tempDir, @NotNull File binReportFile, @NotNull Set<String> excludedClasses, @NotNull Set<String> includedClasses) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)binReportFile, (String)"binReportFile");
        Intrinsics.checkNotNullParameter(excludedClasses, (String)"excludedClasses");
        Intrinsics.checkNotNullParameter(includedClasses, (String)"includedClasses");
        return JacocoOnlineInstrumentationKt.buildJvmAgentArgs(jarFile, binReportFile, excludedClasses, includedClasses);
    }

    @Override
    public void xmlReport(@NotNull File xmlFile, @NotNull String title, @NotNull ReportContext context) {
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JacocoHtmlOrXmlReportKt.jacocoXmlReport(context, xmlFile, title);
    }

    @Override
    public void htmlReport(@NotNull File htmlDir, @NotNull String title, @Nullable String charset, @NotNull ReportContext context) {
        Intrinsics.checkNotNullParameter((Object)htmlDir, (String)"htmlDir");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JacocoHtmlOrXmlReportKt.jacocoHtmlReport(context, htmlDir, title, charset);
    }

    @Override
    public void binaryReport(@NotNull File binary, @NotNull ReportContext context) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        throw new GradleException("It is not possible to generate an Kover binary report for JaCoCo. Please use Kover toolset");
    }

    @Override
    public void verify(@NotNull List<? extends VerificationRule> rules, @NotNull File output, @NotNull ReportContext context) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VerificationKt.doJacocoVerify(context, rules, output);
    }

    @Override
    public void collectCoverage(@NotNull CoverageRequest request, @NotNull File outputFile, @NotNull ReportContext context) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PrintCoverageKt.printJacocoCoverage(context, request, outputFile);
    }
}

