/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tools.kover;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.kover.features.jvm.KoverFeatures;
import kotlinx.kover.features.jvm.KoverLegacyFeatures;
import kotlinx.kover.gradle.plugin.commons.ReportContext;
import kotlinx.kover.gradle.plugin.commons.VerificationRule;
import kotlinx.kover.gradle.plugin.tools.CoverageRequest;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import kotlinx.kover.gradle.plugin.tools.CoverageToolVariant;
import kotlinx.kover.gradle.plugin.tools.kover.EvaluationKt;
import kotlinx.kover.gradle.plugin.tools.kover.IcReportKt;
import kotlinx.kover.gradle.plugin.tools.kover.KoverFeaturesIntegrationKt;
import kotlinx.kover.gradle.plugin.tools.kover.KoverHtmlOrXmlReportKt;
import kotlinx.kover.gradle.plugin.tools.kover.KoverOnlineInstrumentationKt;
import kotlinx.kover.gradle.plugin.tools.kover.KoverTool;
import org.gradle.api.GradleException;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J*\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JB\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060#2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060(H\u0016J&\u0010*\u001a\u00020\u00102\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0#2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00060"}, d2={"Lkotlinx/kover/gradle/plugin/tools/kover/KoverTool;", "Lkotlinx/kover/gradle/plugin/tools/CoverageTool;", "variant", "Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "(Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;)V", "jvmAgentDependency", "", "getJvmAgentDependency", "()Ljava/lang/String;", "jvmReporterDependency", "getJvmReporterDependency", "jvmReporterExtraDependency", "getJvmReporterExtraDependency", "getVariant", "()Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "binaryReport", "", "binary", "Ljava/io/File;", "context", "Lkotlinx/kover/gradle/plugin/commons/ReportContext;", "collectCoverage", "request", "Lkotlinx/kover/gradle/plugin/tools/CoverageRequest;", "outputFile", "findJvmAgentJar", "classpath", "Lorg/gradle/api/file/FileCollection;", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "htmlReport", "htmlDir", "title", "charset", "jvmAgentArgs", "", "jarFile", "tempDir", "binReportFile", "excludedClasses", "", "includedClasses", "verify", "rules", "Lkotlinx/kover/gradle/plugin/commons/VerificationRule;", "output", "xmlReport", "xmlFile", "kover-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nKoverTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoverTool.kt\nkotlinx/kover/gradle/plugin/tools/kover/KoverTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1549#2:75\n1620#2,3:76\n*S KotlinDebug\n*F\n+ 1 KoverTool.kt\nkotlinx/kover/gradle/plugin/tools/kover/KoverTool\n*L\n59#1:75\n59#1:76,3\n*E\n"})
public final class KoverTool
implements CoverageTool {
    @NotNull
    private final CoverageToolVariant variant;
    @NotNull
    private final String jvmAgentDependency;
    @NotNull
    private final String jvmReporterDependency;
    @NotNull
    private final String jvmReporterExtraDependency;

    public KoverTool(@NotNull CoverageToolVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.variant = variant;
        this.jvmAgentDependency = "org.jetbrains.kotlinx:kover-jvm-agent:" + KoverFeatures.INSTANCE.getVersion();
        this.jvmReporterDependency = this.getJvmAgentDependency();
        this.jvmReporterExtraDependency = this.getJvmAgentDependency();
    }

    @Override
    @NotNull
    public CoverageToolVariant getVariant() {
        return this.variant;
    }

    @Override
    @NotNull
    public String getJvmAgentDependency() {
        return this.jvmAgentDependency;
    }

    @Override
    @NotNull
    public String getJvmReporterDependency() {
        return this.jvmReporterDependency;
    }

    @Override
    @NotNull
    public String getJvmReporterExtraDependency() {
        return this.jvmReporterExtraDependency;
    }

    @Override
    @NotNull
    public File findJvmAgentJar(@NotNull FileCollection classpath, @NotNull ArchiveOperations archiveOperations) {
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)archiveOperations, (String)"archiveOperations");
        Set set = classpath.filter((Spec)findJvmAgentJar.1.INSTANCE).getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"classpath.filter { it.na\u2026kover-jvm-agent\") }.files");
        File file = (File)CollectionsKt.firstOrNull((Iterable)set);
        if (file == null) {
            throw new GradleException("JVM instrumentation agent not found for Kover Coverage Tool");
        }
        return file;
    }

    @Override
    @NotNull
    public List<String> jvmAgentArgs(@NotNull File jarFile, @NotNull File tempDir, @NotNull File binReportFile, @NotNull Set<String> excludedClasses, @NotNull Set<String> includedClasses) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)binReportFile, (String)"binReportFile");
        Intrinsics.checkNotNullParameter(excludedClasses, (String)"excludedClasses");
        Intrinsics.checkNotNullParameter(includedClasses, (String)"includedClasses");
        return KoverOnlineInstrumentationKt.buildJvmAgentArgs(jarFile, tempDir, binReportFile, excludedClasses, includedClasses);
    }

    @Override
    public void xmlReport(@NotNull File xmlFile, @NotNull String title, @NotNull ReportContext context) {
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KoverHtmlOrXmlReportKt.koverXmlReport(context, xmlFile, title);
    }

    @Override
    public void htmlReport(@NotNull File htmlDir, @NotNull String title, @Nullable String charset, @NotNull ReportContext context) {
        Intrinsics.checkNotNullParameter((Object)htmlDir, (String)"htmlDir");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KoverHtmlOrXmlReportKt.koverHtmlReport(context, htmlDir, title, charset);
    }

    @Override
    public void binaryReport(@NotNull File binary, @NotNull ReportContext context) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IcReportKt.koverBinaryReport(context, binary);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void verify(@NotNull List<? extends VerificationRule> rules, @NotNull File output, @NotNull ReportContext context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable iterable = rules;
        KoverLegacyFeatures koverLegacyFeatures = KoverLegacyFeatures.INSTANCE;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VerificationRule verificationRule = (VerificationRule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(KoverFeaturesIntegrationKt.convert((VerificationRule)it));
        }
        List violations = koverLegacyFeatures.verify((List)destination$iv$iv, context.getTempDir(), KoverFeaturesIntegrationKt.toKoverFeatures(context.getFilters()), CollectionsKt.toList((Iterable)context.getFiles().getReports()), CollectionsKt.toList((Iterable)context.getFiles().getOutputs()));
        String errorMessage = KoverLegacyFeatures.INSTANCE.violationMessage(violations);
        FilesKt.writeText$default((File)output, (String)errorMessage, null, (int)2, null);
    }

    @Override
    public void collectCoverage(@NotNull CoverageRequest request, @NotNull File outputFile, @NotNull ReportContext context) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        EvaluationKt.printCoverage(context, request, outputFile);
    }
}

